<?php
// require login
$Auth->requireUser(WEB_ROOT . '/login.' . SITE_CONFIG_PAGE_EXTENSION);

coreFunctions::limitEmailsSentPerHour();

/* load file */
if (isset($_REQUEST['u']))
{
    $file = file::loadById($_REQUEST['u']);
    if (!$file)
    {
        // failed lookup of file
        coreFunctions::redirect(WEB_ROOT . '/account_home.' . SITE_CONFIG_PAGE_EXTENSION);
    }

    // check current user has permission to edit file
    if ($file->userId != $Auth->id)
    {
        coreFunctions::redirect(WEB_ROOT . '/account_home.' . SITE_CONFIG_PAGE_EXTENSION);
    }
}
else
{
    coreFunctions::redirect(WEB_ROOT . '/account_home.' . SITE_CONFIG_PAGE_EXTENSION);
}
$accountLocked = 0;
if(SITE_CONFIG_SECURITY_ACCOUNT_LOCK == 'yes' && coreFunctions::getUsersAccountLockStatus($Auth->id))
{
    $accountLocked = 1;
}

$isPublic = 1;
if(corefunctions::getOverallPublicStatus($Auth->id, $file->folderId, $file->id) == false)
{
    $isPublic = 0;
}
$isFolderPublic = 1;
if(coreFunctions::getUserFoldersPublicStatus($file->folderId) == false)
{
    $isFolderPublic = 0;
}

?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="la la-close"></i></button>
    <h4 class="modal-title"><strong><?php echo validation::safeOutputToScreen($file->originalFilename); ?></strong> <?php echo t("hg_", "Links")?></h4>
</div>
<div class="modal-body">
  <div class="row">
	<div class="col-md-12 pt20">
	  <div class="well2">
	    <div class="form-horizontal">
		  <div class="form-group">
		    <label class="col-md-3 control-label"><?php echo t("hg_dl", "Download Link")?></label>
			<div class="input-group col-md-8">
			  <input id="dlLink" class="form-control input-sm" value="<?php echo validation::safeOutputToScreen($file->getFullShortUrl()); ?>" type="text" readonly="">
			    <span class="input-group-btn">
				  <button class="btn btn-sm" data-clipboard-action="copy" data-clipboard-target="#dlLink" type="button"><i class="zmdi zmdi-copy zmdi-hc-fw"></i> <?php echo t("hg_", "Copy")?></button>
				</span>
			</div>
		  </div>
		  <div class="form-group">
		    <label class="col-md-3 control-label"><?php echo t("hg_html", "HTML Code")?></label>
			<div class="input-group col-md-8">
			  <input id="html" class="form-control input-sm" value="<?php echo $file->getHtmlLinkCode(); ?>" type="text" readonly="">
			    <span class="input-group-btn">
				  <button class="btn btn-sm" data-clipboard-action="copy" data-clipboard-target="#html" type="button"><i class="zmdi zmdi-copy zmdi-hc-fw"></i> <?php echo t("hg_", "Copy")?></button>
				</span>
			</div>
		  </div>
		  <div class="form-group">
		    <label class="col-md-3 control-label"><?php echo t("hg_bb", "Forum Code")?></label>
			<div class="input-group col-md-8">
			  <input id="forum" class="form-control input-sm" value="<?php echo $file->getForumLinkCode(); ?>" type="text" readonly="">
			    <span class="input-group-btn">
				  <button class="btn btn-sm" data-clipboard-action="copy" data-clipboard-target="#forum" type="button"><i class="zmdi zmdi-copy zmdi-hc-fw"></i> <?php echo t("hg_", "Copy")?></button>
				</span>
			</div>
		  </div>
		  
		  <div class="form-group">
		    <label class="col-md-3 control-label"><?php echo t("hg_stats", "Statistic Link")?></label>
			<div class="input-group col-md-8">
			  <input id="stats" class="form-control input-sm" value="<?php echo validation::safeOutputToScreen($file->getStatisticsUrl()); ?>" type="text" readonly="">
			    <span class="input-group-btn">
				  <button class="btn btn-sm" data-clipboard-action="copy" data-clipboard-target="#stats" type="button"><i class="zmdi zmdi-copy zmdi-hc-fw"></i> <?php echo t("hg_", "Copy")?></button>
				</span>
			</div>
		  </div>
		  <div class="form-group">
		    <label class="col-md-3 control-label"><?php echo t("hg_public", "Public Information")?></label>
			<div class="input-group col-md-8">
			  <input id="pub" class="form-control input-sm" value="<?php echo validation::safeOutputToScreen($file->getInfoUrl()); ?>" type="text" readonly="">
			    <span class="input-group-btn">
				  <button class="btn btn-sm" data-clipboard-action="copy" data-clipboard-target="#pub" type="button"><i class="zmdi zmdi-copy zmdi-hc-fw"></i> <?php echo t("hg_", "Copy")?></button>
				</span>
			</div>
		  </div>
		  <div class="form-group">
		    <label class="col-md-3 control-label"><?php echo t("hg_del", "Delete Link")?></label>
			<div class="input-group col-md-8">
			  <input id="del" class="form-control input-sm" value="<?php echo validation::safeOutputToScreen($file->getDeleteUrl()); ?>" type="text" readonly="">
			    <span class="input-group-btn">
				  <button class="btn btn-sm" data-clipboard-action="copy" data-clipboard-target="#del" type="button"><i class="zmdi zmdi-copy zmdi-hc-fw"></i> <?php echo t("hg_", "Copy")?></button>
				</span>
			</div>
		  </div>
		</div>
	  </div>
	</div>
  </div>
</div>