<?php

// require login
$Auth->requireUser(WEB_ROOT . '/login.' . SITE_CONFIG_PAGE_EXTENSION);

// setup database
$db = Database::getDatabase(true);

// load existing folder data
$fileFolder = fileFolder::loadById((int)$_REQUEST['folderId']);
if ($fileFolder)
{
	// load the folder url
	$pageUrl = $fileFolder->getFolderUrl();
	
	// check current user has permission to access the fileFolder
	if ($fileFolder->userId != $Auth->id)
	{
		// setup edit folder
		die('No access permitted.');
	}
}

// privacy check
$isPublic = true;
$shareLink = $pageUrl;
if(coreFunctions::getOverallPublicStatus(0, $fileFolder->id) == false)
{
	$isPublic = false;
	$shareLink = 'SHARE_LINK';
}

define('SHARE_URLS_TEMPLATE', '<!-- just add href= for your links, like this: -->
	<a href="https://www.facebook.com/sharer/sharer.php?u='.validation::safeOutputToScreen($shareLink).'" target="_blank" class="btn btn-social-icon btn-facebook"><i class="zmdi zmdi-facebook"></i> Facebook</a>
	<a href="https://twitter.com/share?url='.validation::safeOutputToScreen($shareLink).'" target="_blank" class="btn btn-social-icon btn-twitter"><i class="zmdi zmdi-twitter"></i> Twitter</a>							
	<a href="https://plus.google.com/share?url='.validation::safeOutputToScreen($shareLink).'" target="_blank" class="btn btn-social-icon btn-google-plus"><i class="zmdi zmdi-google-plus"></i> Google+</a>
	<a href="https://www.linkedin.com/cws/share?url='.validation::safeOutputToScreen($shareLink).'" target="_blank" class="btn btn-social-icon btn-linkedin"><i class="zmdi zmdi-linkedin"></i> Linkedin</a>
	
	<a href="http://reddit.com/submit?url='.validation::safeOutputToScreen($shareLink).'&title='.urlencode(validation::safeOutputToScreen($fileFolder->folderName)).'" target="_blank" class="btn btn-social-icon btn-reddit"><i class="zmdi zmdi-reddit"></i> Reddit</a>
	<a href="https://www.tumblr.com/widgets/share/tool?canonicalUrl='.validation::safeOutputToScreen($shareLink).'&title='.urlencode(validation::safeOutputToScreen($fileFolder->folderName)).'&caption='.urlencode(validation::safeOutputToScreen($fileFolder->folderName)).'" target="_blank" class="btn btn-social-icon btn-tumblr"><i class="zmdi zmdi-tumblr"></i> Tumblr</a>');
?>

<div class="modal-header">
	<button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="la la-close"></i></button>
	<h4 class="modal-title"><?php echo t("share_folder", "share folder"); ?>: <?php echo validation::safeOutputToScreen($fileFolder->folderName); ?></h4>
</div>

<div class="modal-body">
	<div class="row">
		
		<div class="col-md-12">
			
			<?php if($isPublic == true): ?>
			<div class="row">
				<div class="col-md-12 form-horizontal">
					<div class="form-group">
						<label for="folderName" class="control-label col-md-3"><?php echo t('edit_folder_sharing_url', 'Sharing Url:'); ?></label>
						<div class="col-md-8">
						  <div class="input-group">
							<input type="text" readonly class="form-control" onClick="selectAllText(this); return false;" id="folderUrlSection" value="<?php echo validation::safeOutputToScreen($pageUrl); ?>">
							<span class="input-group-btn">
								<button id="copyToClipboardBtn" type="button" class="btn btn-copy" data-clipboard-action="copy" data-clipboard-target="#folderUrlSection" onClick="copyToClipboard('#copyToClipboardBtn'); return false;"><i class="la la-copy"></i></button>
							</span>
						  </div>
						</div>
						
					</div>
					<div class=" col-md-12 pt30 social-wrapper">
					   <?php echo SHARE_URLS_TEMPLATE; ?>
                    </div>
				</div>
			</div>
			<?php endif; ?>
			
			<?php if($isPublic == false): ?>
			<div class="row">
				<div class="col-md-12 form-horizontal">
					<div class="form-group">
						<label for="folderName" class="control-label col-md-3"><?php echo t('edit_folder_sharing_url', 'Sharing Url:'); ?></label>
						<div class="col-md-8">
						  <div class="input-group">
							<input  type="text" readonly class="form-control" id="sharingUrlInput" onClick="selectAllText(this); return false;" value="" placeholder="Click 'refresh' button to generate...">
							<span class="input-group-btn" style="vertical-align: top;">
								<button type="button" class="btn btn-copy" onClick="generateFolderSharingUrl(<?php echo (int)$fileFolder->id; ?>); return false;" title="Click to generate the sharing url..."><i class="la la-refresh"></i></button>
							</span>
						  </div>
						</div>
					</div>
					<div id="nonPublicSharingUrls"  class="col-md-12 pt30 social-wrapper" style="display: none;">
					   <?php echo SHARE_URLS_TEMPLATE; ?>
                    </div>
					<div class="col-md-12 pt30 social-wrapper social-wrapper-template" style="display: none;">
					   <?php echo SHARE_URLS_TEMPLATE; ?>
                    </div>
				</div>
			</div>
			<?php endif; ?>
			
			<div id="showMore" style="display: none;">
			  <form action="<?php echo WEB_ROOT; ?>/ajax/_email_folder_url.process.ajax.php" autocomplete="off">
			  <div class="row">
				<div class="col-md-12 pt20 form-horizontal">
				  <div class="form-group">
				    <label class="control-label col-md-3">Email Address</label>
					<div class="col-md-8">
					  <input type="text" class="form-control" name="shareEmailAddress" id="shareEmailAddress"/>
					</div>
				  </div>
				  <div class="form-group">
				    <label class="control-label col-md-3">Extra Text</label>
					<div class="col-md-8">
					  <textarea id="shareExtraMessage" rows="5" name="shareExtraMessage" class="form-control" placeholder="<?php echo UCWords(t("extra_mesage", "(optional)")); ?>"></textarea>
					</div>
				  </div>
				  <div class="form-group">
					<div class="col-md-4 col-md-offset-3">
					  <input name="shareEmailFolderUrl" id="shareEmailFolderUrl" type="hidden" value="<?php echo ($isPublic == true)?validation::safeOutputToScreen($pageUrl):''; ?>"/>
					  <input type="hidden" name="submitme" id="submitme" value="1"/>
					  <input type="hidden" value="<?php echo (int) $fileFolder->id; ?>" name="folderId"/>
					  <button type="button" class="btn btn-block btn-primary btn-upload" onClick="processAjaxForm(this, function() { $('#shareEmailAddress').val(''); $('#shareExtraMessage').val(''); }); return false;"><i class="la la-envelope"></i> <?php echo UCWords(t("send_email", "send email")); ?></button>
					</div>
				  </div>
				</div>
			  </div>
			  </form>
			</div>
		</div>
	</div>
</div>

    <div class="modal-footer">
        <a type="button" class="btn btn-info btn-options showMore"><i class="la la-envelope"></i> Share via email</a>
    </div>