<?php
// require login
$Auth->requireUser(WEB_ROOT . '/login.' . SITE_CONFIG_PAGE_EXTENSION);

coreFunctions::limitEmailsSentPerHour();

/* load file */
if (isset($_REQUEST['u']))
{
    $file = file::loadById($_REQUEST['u']);
    if (!$file)
    {
        // failed lookup of file
        coreFunctions::redirect(WEB_ROOT . '/account_home.' . SITE_CONFIG_PAGE_EXTENSION);
    }

    // check current user has permission to edit file
    if ($file->userId != $Auth->id)
    {
        coreFunctions::redirect(WEB_ROOT . '/account_home.' . SITE_CONFIG_PAGE_EXTENSION);
    }
}
else
{
    coreFunctions::redirect(WEB_ROOT . '/account_home.' . SITE_CONFIG_PAGE_EXTENSION);
}
$accountLocked = 0;
if(SITE_CONFIG_SECURITY_ACCOUNT_LOCK == 'yes' && coreFunctions::getUsersAccountLockStatus($Auth->id))
{
    $accountLocked = 1;
}

$isPublic = 1;
if(corefunctions::getOverallPublicStatus($Auth->id, $file->folderId, $file->id) == false)
{
    $isPublic = 0;
}
$isFolderPublic = 1;
if(coreFunctions::getUserFoldersPublicStatus($file->folderId) == false)
{
    $isFolderPublic = 0;
}

?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="la la-close"></i></button>
    <h4 class="modal-title">Send it via email</h4>
	<p class="subtitle"><?php echo t('account_file_details_intro_user_the_form_below_send_email', 'Use the form below to share this file via email. The recipient will receive a link to download the file.') ; ?></p>
</div>
    <div class="modal-body form-horizontal">
        <?php if ($file->statusId == 1): ?>
            <div class="row">
                <form action="<?php echo WEB_ROOT; ?>/ajax/_account_file_details_send_email.process.ajax.php" autocomplete="off">
                    <?php if ($isPublic == 1): ?>
                        <div class="form-group">
                            <label class="control-label col-md-3" for="shareRecipientName"><?php echo UCWords(t("recipient_name", "recipient full name")); ?>:</label>
                            <div class="col-md-8">
							<input type="text" id="shareRecipientName" name="shareRecipientName" class="form-control"/>
                            </div>
						</div>

                        <div class="form-group">
                            <label class="control-label col-md-3" for="shareEmailAddress"><?php echo UCWords(t("recipient_email_address", "recipient email address")); ?>:</label>
                            <div class="col-md-8">
							<input type="text" id="shareEmailAddress" name="shareEmailAddress" class="form-control"/>
							</div>
                        </div>

                        <div class="form-group">
							<label class="control-label textarea-label col-md-3" for="shareExtraMessage"><?php echo UCWords(t("extra_message", "extra message")); ?>:</label>
                            <div class="col-md-8">
							<textarea id="shareExtraMessage" rows="5" name="shareExtraMessage" class="form-control"></textarea>
							</div>
                        </div>

                        
                        <?php else: ?>
                        <div class="form-group"> 
                            <p><?php echo t('account_file_details_send_email_links_disabled', 'Sharing links has been disabled on this file.') ; ?></p> 
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3" for="shareRecipientName"><?php echo UCWords(t("recipient_name", "recipient full name")); ?>:</label>
                            <div class="col-md-8">
							<input type="text" id="shareRecipientName" name="shareRecipientName" class="form-control" disabled/>
							</div>
                        </div>

                        <div class="form-group">
                            <label class="control-labe col-md-3l" for="shareEmailAddress"><?php echo UCWords(t("recipient_email_address", "recipient email address")); ?>:</label>
                            <div class="col-md-8">
							<input type="text" id="shareEmailAddress" name="shareEmailAddress" class="form-control" disabled/>
                            </div>
						</div>

                        <div class="form-group">
                            <label class="control-label col-md-3 textarea-label" for="shareExtraMessage"><?php echo UCWords(t("extra_message", "extra message")); ?>:</label>
                            <div class="col-md-8">
							<textarea id="shareExtraMessage" rows="5" name="shareExtraMessage" class="form-control" disabled></textarea>
                            </div>
						</div>

                       
                        <?php endif; ?>
                        
                
            </div>
        <?php endif; ?>
    </div>
<div class="modal-footer">
<?php if ($isPublic == 1): ?>
 <input type="hidden" name="submitme" id="submitme" value="1"/>
                            <input type="hidden" value="<?php echo (int) $file->id; ?>" name="fileId"/>
                            <button type="button" class="btn btn-primary btn-upload" onClick="processAjaxForm(this, function() { $('#shareRecipientName').val(''); $('#shareEmailAddress').val(''); $('#shareExtraMessage').val(''); }); return false;"><i class="la la-envelope"></i> <?php echo UCWords(t("send_email", "send email")); ?></button>
    <?php else: ?>
	<input type="hidden" name="submitme" id="submitme" value="1"/>
                            <input type="hidden" value="<?php echo (int) $file->id; ?>" name="fileId"/>
                            <button type="button" class="btn btn-primary btn-upload" onClick="processAjaxForm(this, function() { $('#shareRecipientName').val(''); $('#shareEmailAddress').val(''); $('#shareExtraMessage').val(''); }); return false;" disabled><i class="la la-envelope"></i>  <?php echo UCWords(t("send_email", "send email")); ?></button>
<?php endif; ?>
							</div>
</form>