<script type="text/javascript">
    var selectedFiles = [];
    var selectedFolders = [];
    var cur = -1, prv = -1;
    var pageStart = 0;
    var perPage = <?php echo $defaultPerPage; ?>;
    var fileId = 0;
    var intialLoad = true;
    var uploaderShown = false;
    var fromFilterModal = false;
    var doubleClickTimeout = null;
    var triggerTreeviewLoad = true;
    var filePopupSelectedTab = 0;
    var currentFolderId = -1;
    $(function () {
        // initial button state
        updateFileActionButtons();

        // load folder listing
        $("#folderTreeview").jstree({
            "plugins": [
                "themes", "json_data", "ui", "types", "crrm", "contextmenu", "cookies"
            ],
            "themes": {
                "theme": "default",
                "dots": false,
                "icons": true
            },
            "core": {"animation": 150},
            "json_data": {
                "data": [
                    {
                        "data": "<?php echo t('your_uploads', 'Your Uploads'); ?>",
                        "state": "closed",
                        "attr": {"id": "-1", "rel": "home", "original-text": "<?php echo str_replace("\"", "'", t('your_uploads', 'Your Uploads')); ?>"}
                    },
                    {
                        "data": "<?php echo t('recent_uploads', 'Recent Uploads'); ?>",
                        "attr": {"id": "recent", "rel": "recent", "original-text": "<?php echo str_replace("\"", "'", t('recent_uploads', 'Recent Uploads')); ?>"}
                    },
                    {
                        "data": "<?php echo t('all_files', 'All Files'); ?><?php echo ($totalActive > 0) ? (' (' . $totalActive . ')') : ''; ?>",
                        "attr": {"id": "all", "rel": "all", "original-text": "<?php echo str_replace("\"", "'", t('all_files', 'All Files')); ?>"}
                    },
                    {
                        "data": "<?php echo t('trash_can', 'Trash Can'); ?><?php echo (isset($totalTrash) && ($totalTrash > 0)) ? (' (' . $totalTrash . ')') : ''; ?>",
                        "attr": {"id": "trash", "rel": "bin", "original-text": "<?php echo str_replace("\"", "'", t('trash_can', 'Trash Can')); ?>"}
                    }
                ],
                "ajax": {
                    "url": function (node) {
                        var nodeId = "";
                        var url = ""
                        if (node == -1)
                        {
                            url = "<?php echo CORE_AJAX_WEB_ROOT; ?>/_account_home_v2_folder_listing.ajax.php";
                        } else
                        {
                            nodeId = node.attr('id');
                            url = "<?php echo CORE_AJAX_WEB_ROOT; ?>/_account_home_v2_folder_listing.ajax.php?folder=" + nodeId;
                        }

                        return url;
                    }
                }
            },
            "contextmenu": {
                "items": buildTreeViewContextMenu
            },
            'progressive_render': true
        }).bind("dblclick.jstree", function (event, data) {
            if (doubleClickTimeout != null)
            {
                clearTimeout(doubleClickTimeout);
                doubleClickTimeout = null;
            }
            var node = $(event.target).closest("li");
            if ($(node).hasClass('jstree-leaf') == true)
            {
                return false;
            }

            //$("#folderTreeview").jstree("toggle_node", node.data("jstree"));
        }).bind("select_node.jstree", function (event, data) {
            // use this to stop the treeview from triggering a reload of the file manager
            if (triggerTreeviewLoad == false)
            {
                triggerTreeviewLoad = true;
                return false;
            }
            // add a slight delay encase this is a double click
            if (intialLoad == false)
            {
                clickTreeviewNode(data);

                return false;
            }

            clickTreeviewNode(data);
        }).bind("load_node.jstree", function (event, data) {
            // assign click to icon
            assignNodeExpandClick();
        }).bind("open_node.jstree", function (event, data) {
            // reassign drag crop for sub-folder
            setupTreeviewDropTarget();
        }).delegate("a", "click", function (event, data) {
            event.preventDefault();
        }).bind('loaded.jstree', function (e, data) {
            // reload stats
            updateStatsViaAjax();
        });

        var doIntial = inFileManager();
        if (typeof ($.cookie("jstree_select")) != "undefined")
        {
            if ($.cookie("jstree_select").length > 0)
            {
                doIntial = false;
            }
        }
        if (doIntial == true)
        {
            // load file listing
            $('#nodeId').val('-1');
            loadFiles();
        }

        resetStartPoint();

        if (inFileManager() == true)
        {
            $('.file-manager-container').bind('drop', function (e) {
                // blocks upload popup on internal moves / folder icons
                if ($(e.target).hasClass('folderIconLi') == false)
                {
                    uploadFiles();
                }
            });

            $("#fileManager").click(function(event) {
                if (ctrlPressed == false)
                {
                    if ($(event.target).is('ul') || $(event.target).hasClass('fileManager')) {
                        clearSelectedItems();
                    }
                }
            });

            setupFileDragSelect();

<?php if (SITE_CONFIG_FILE_MANAGER_DEFAULT_VIEW == 'list'): ?>
                toggleViewType();
<?php endif; ?>

            // setup key shortcuts
            $(window).keyup(function (e) {
                // escape, hide any context menus
                if (e.keyCode == 27) {
                    hideOpenContextMenus();
                }
                // delete key
                if (e.keyCode == 46) {
                    trashFiles();
                }

                // navigate files
                if (e.keyCode == 37)
                {
                    selectPreviousFile();
                    return false;
                } else if (e.keyCode == 39)
                {
                    selectNextFile();
                    return false;
                }
            });

            // make sure the user wants to exit is they are uploading
            $(window).bind('beforeunload', function () {
                if (uploadComplete == false)
                {
                    return 'You still have 1 or more uploads in progress, are you sure you want to exit?';
                }
            });
        }
    });

    function setCurrentFolderId(folderId) {
        currentFolderId = folderId;
        $('#nodeId').val(currentFolderId);
        $('#folderIdDropdown').val(currentFolderId);
        //setLastLoadedFolderCookie(folderId);
        if (typeof (setUploadFolderId) === 'function')
        {
            setUploadFolderId(folderId);
        }
    }

    function getCurrentFolderId() {
        return currentFolderId;
    }

    function assignNodeExpandClick()
    {
        $('.jstree-icon').off('click');
        $('.jstree-icon').on('click', function (event) {
            var node = $(event.target).parent().parent();
            if ($(node).hasClass('jstree-leaf') != true)
            {
                // expand
                $("#folderTreeview").jstree("toggle_node", $(node));

                // stop the node from being selected
                event.stopPropagation();
                event.preventDefault();
            }
        });
    }

    function clickTreeviewNode(data)
    {
        if (doubleClickTimeout != null)
        {
            clearTimeout(doubleClickTimeout);
            doubleClickTimeout = null;
        }

        clearSelectedItems();
        clearSearchFilters(false);
        if (inFileManager() == true)
        {
            // load via ajax
            if (intialLoad == true)
            {
                intialLoad = false;
            }

            setCurrentFolderId(data.rslt.obj.attr("id"));
            refreshFolderBreadcrumbs();
            if (typeof (setUploadFolderId) === 'function')
            {
                setUploadFolderId($('#nodeId').val());
            }
            refreshFileListing();
        } else
        {
            // block initial load so we don't get random redirects
            if (intialLoad == true)
            {
                intialLoad = false;
            } else
            {
                // do full page load as not currently in file manager
                window.location = "<?php echo WEB_ROOT; ?>/account_home.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>?folderId=" + data.rslt.obj.attr("id");
            }
        }
    }

    function refreshFileListing()
    {
        resetStartPoint();
        loadFiles();
        updateFolderDropdownMenuItems();
        assignNodeExpandClick();
    }

    function updateFolderDropdownMenuItems()
    {
        // not a sub folder
        if (isPositiveInteger($('#nodeId').val()) == false)
        {
            $('#subFolderOptions').hide();
            $('#topFolderOptions').show();
        }
        // all sub folders / menu options
        else
        {
            $('#topFolderOptions').hide();
            $('#subFolderOptions').show();
        }
    }

    function setupFileDragSelect()
    {
        if (isDesktopUser() == true)
        {
            $('.file-manager-container')
                    .drag("start", function (ev, dd) {
                        //unbindLiOnClick();
                        return $('<div class="fileManagerDraggleSelection" />')
                                .css('opacity', .50)
                                .appendTo(document.body);
                    })
                    .drag(function (ev, dd) {
                        $(dd.proxy).css({
                            top: Math.min(ev.pageY, dd.startY),
                            left: Math.min(ev.pageX, dd.startX),
                            height: Math.abs(ev.pageY - dd.startY),
                            width: Math.abs(ev.pageX - dd.startX)
                        });
                    })
                    .drag("end", function (ev, dd) {
                        //assignLiOnClick();
                        $(dd.proxy).remove();
                    }, {distance: 10, not: $('li, span, a, img')});

            $('.fileIconLi, .folderIconLi').draggable({
                revert: function (event, ui) {
                    return !event;
                },
                containment: 'body',
                helper: function (event) {
                    if(typeof($(this).attr('fileId')) != 'undefined') {
                        selectFile($(this).attr('fileId'), true);
                    }
                    else {
                        selectFolder($(this).attr('folderId'), true);
                    }
                    var ret = $(this).clone();
                    ret.find('.filename').html('<?php echo t('file_manager_moving', 'Moving'); ?> ' + countSelected() + ' <?php echo t('file_manager_moving_items', 'items(s)'); ?>');
                    ret.find('.fileUploadDate').remove();
                    ret.find('.filesize').remove();
                    ret.find('.fileOptions').remove();
                    ret.find('.downloads').remove();
                    return ret;
                },
                opacity: 0.50,
                cursorAt: {left: 5, top: 5},
                distance: 10,
                start: function (event, ui)
                {
                    if(typeof($(this).attr('fileId')) != 'undefined') {
                        selectFile($(this).attr('fileId'), true);
                    }
                    else {
                        selectFolder($(this).attr('folderId'), true);
                    }
                },
                stop: function (event, ui)
                {
                    // clear selected if only 1
                    if (countSelected() == 1) {
                        if(typeof($(this).attr('fileId')) != 'undefined') {
                            elementId = 'fileItem' + $(this).attr('fileId');
                            $('.' + elementId).removeClass('selected');
                            delete selectedFiles['k' + $(this).attr('fileId')];
                        }
                        else {
                            elementId = 'folderItem' + $(this).attr('folderId');
                            $('.' + elementId).removeClass('selected');
                            delete selectedFolders['k' + $(this).attr('folderId')];
                        }
                    }
                }
            });

            setupTreeviewDropTarget();
        }
    }

    function setupTreeviewDropTarget()
    {
        $(".jstree-no-dots li a").droppable({
            hoverClass: 'jstree-hovered',
            tolerance: "pointer",
            drop: function (event, ui) {
                folderId = $(this).parent().attr('id');
                moveFiles(folderId);
            }
        });

        $(".fileManagerWrapper .fileListing .folderIconLi").droppable({
            hoverClass: 'jstree-hovered',
            tolerance: "pointer",
            drop: function (event, ui) {
                folderId = $(this).attr('folderid');
                moveFiles(folderId);
            }
        });
    }

    function moveFiles(newFolderId)
    {
        if ((newFolderId == 'recent') || (newFolderId == 'all'))
        {
            return true;
        }

        if (newFolderId == 'trash')
        {
            trashFiles();
            return true;
        }

        moveFilesIntoFolder(newFolderId);

        return true;
    }

    function moveFilesIntoFolder(newFolderId)
    {
        fileIds = getAllSelectedFileIds();
        folderIds = getAllSelectedFolderIds();

        $.ajax({
            dataType: "json",
            url: "<?php echo CORE_AJAX_WEB_ROOT; ?>/_account_move_file_in_folder.ajax.php",
            data: {folderId: newFolderId, fileIds: fileIds, folderIds: folderIds},
            success: function (data) {
                if (data.error == true)
                {
                    alert(data.msg);
                } else
                {
                    // refresh treeview
                    refreshFolderListing(false);
                    refreshFileListing();

                    // clear selected
                    clearSelectedItems();

                    // reload stats
                    updateStatsViaAjax();
                }
            }
        });
    }

    function reloadDragItems()
    {
        $('.fileIconLi, .folderIconLi')
                .drop("start", function () {
                    $(this).removeClass("active");
                    if ($(this).hasClass("selected") == false)
                    {
                        $(this).addClass("active");
                    }
                })
                .drop(function (ev, dd) {
                    if(typeof($(this).attr('fileId')) != 'undefined') {
                        selectFile($(this).attr('fileId'), true);
                    }
                    else {
                        selectFolder($(this).attr('folderId'), true);
                    }
                })
                .drop("end", function () {
                    $(this).removeClass("active");
                });
        $.drop({multi: true});
    }

    function setLastLoadedFolderCookie(folderId)
    {
        // @TODO - store the path to the current folder to it's correctly reloaded,
        // this is only done when someone clicks on the folder in the main
        // file view, but it stops things breaking
        $.cookie("jstree_select", "#-1");
        $.cookie("jstree_open", "-1");
    }

    function refreshFolderListing(triggerLoad)
    {
        if (typeof (triggerLoad) != "undefined")
        {
            triggerTreeviewLoad = triggerLoad;
        }

        $("#folderTreeview").jstree("refresh");
    }

    function resetStartPoint()
    {
        pageStart = 0;
    }

    function setPerPage()
    {
        perPage = parseInt($('#perPageElement').val());
        doFilter();
    }

    function buildTreeViewContextMenu(node)
    {
        var items = {};
        if (inFileManager() == false)
        {
            return null;
        }

        var items = {};

        if ($(node).attr('id') == 'trash')
        {
            items["Open"] = {
                "label": "<?php echo t('open_trash', 'Open Trash'); ?>",
                "icon": "glyphicon glyphicon-folder-open",
                "separator_after": true,
                "action": function (obj) {
                    loadFolderFiles(obj.attr("id"));
                }
            };
            items["Empty"] = {
                "label": "<?php echo t('empty_trash', 'Empty Trash'); ?>",
                "icon": "glyphicon glyphicon-trash",
                "action": function (obj) {
                    confirmEmptyTrash();
                }
            };
        } else if ($(node).attr('id') == 'all')
        {
            items["Open"] = {
                "label": "<?php echo t('view_all_uploads', 'View All Uploads'); ?>",
                "icon": "glyphicon glyphicon-folder-open",
                "separator_after": false,
                "action": function (obj) {
                    loadFolderFiles(obj.attr("id"));
                }
            };
        } else if ($(node).attr('id') == 'recent')
        {
            items["Open"] = {
                "label": "<?php echo t('view_recent_uploads', 'View Recent Uploads'); ?>",
                "icon": "glyphicon glyphicon-folder-open",
                "separator_after": false,
                "action": function (obj) {
                    loadFolderFiles(obj.attr("id"));
                }
            };
        } else if ($(node).attr('id') == '-1')
        {
            items["Upload"] = {
                "label": "<?php echo t('upload_files', 'Upload Files'); ?>",
                "separator_after": true,
                "icon": "glyphicon glyphicon-cloud-upload",
                "action": function (obj) {
                    uploadFiles('');
                }
            };
            items["Add"] = {
                "label": "<?php echo t('add_folder', 'Add Folder'); ?>",
                "icon": "glyphicon glyphicon-plus",
                "action": function (obj) {
                    showAddFolderForm(obj.attr("id"));
                }
            };
        } else if ($.isNumeric($(node).attr('id')))
        {
            items["Upload"] = {
                "label": "<?php echo t('upload_files', 'Upload Files'); ?>",
                "icon": "glyphicon glyphicon-cloud-upload",
                "separator_after": true,
                "action": function (obj) {
                    uploadFiles(obj.attr("id"));
                }
            };
            items["Add"] = {
                "label": "<?php echo t('add_sub_folder', 'Add Sub Folder'); ?>",
                "icon": "glyphicon glyphicon-plus",
                "action": function (obj) {
                    showAddFolderForm(obj.attr("id"));
                }
            };
            items["Edit"] = {
                "label": "<?php echo t('edit_folder', 'Edit'); ?>",
                "icon": "glyphicon glyphicon-pencil",
                "action": function (obj) {
                    showAddFolderForm(null, obj.attr("id"));
                }
            };
            items["Delete"] = {
                "label": "<?php echo t('delete_folder', 'Delete'); ?>",
                "icon": "glyphicon glyphicon-trash",
                "action": function (obj) {
                    confirmTrashFolder(obj.attr("id"));
                }
            };
            items["Download"] = {
                "label": "<?php echo t('download_all_files', 'Download All Files (Zip)'); ?>",
                "icon": "glyphicon glyphicon-floppy-save",
                "separator_before": true,
                "action": function (obj) {
                    downloadAllFilesFromFolder(obj.attr("id"));
                }
            };
            items["Share"] = {
                "label": "<?php echo t('share_folder', 'Share Folder'); ?>",
                "icon": "glyphicon glyphicon-share",
                "separator_before": true,
                "action": function (obj) {
                    showFolderSharingForm(obj.attr("id"));
                }
            };
        }

        return items;
    }

    function uploadFiles(folderId)
    {
        if (typeof (folderId) != 'undefined')
        {
            $('#upload_folder_id').val(folderId);
        }

        showUploaderPopup();
    }

    function isPositiveInteger(str)
    {
        var n = ~~Number(str);
        return n > 0;
    }

    function confirmTrashFolder(folderId)
    {
        // only allow actual sub folders
        if (isPositiveInteger(folderId) == false)
        {
            return false;
        }
<?php if (corefunctions::getUsersAccountLockStatus($Auth->id) == 1): ?>
            if (alert('<?php echo str_replace('\'', '', t('account_locked_folder_delete_error_message', 'This account has been locked, please unlock the account to regain full functionality.')); ?>'))
            {
                return false;
            }
<?php elseif (corefunctions::getUsersAccountLockStatus($Auth->id) == 0): ?>
            if (confirm('<?php echo str_replace('\'', '', t('are_you_sure_you_want_to_trash_this_folder_inc_files', 'Are you sure you want to send this folder to trash? Any files within the folder will also be sent to trash.')); ?>'))
            {
                trashFolder(folderId);
            }
<?php endif; ?>
        return false;
    }

    function trashFolder(folderId)
    {
        $.ajax({
            dataType: "json",
            url: "<?php echo CORE_AJAX_WEB_ROOT; ?>/_account_trash_folder.ajax.php",
            data: {folderId: folderId},
            success: function (data) {
                if (data.error == true)
                {
                    showErrorNotification('Error', data.msg);
                } else
                {
                    // refresh treeview
                    showSuccessNotification('Success', data.msg);
                    refreshFolderListing(false);
                    refreshFileListing();
                }
            }
        });
    }

    function confirmDeleteFolder(folderId)
    {
        // only allow actual sub folders
        if (isPositiveInteger(folderId) == false)
        {
            return false;
        }
<?php if (corefunctions::getUsersAccountLockStatus($Auth->id) == 1): ?>
            if (alert('<?php echo str_replace('\'', '', t('account_locked_folder_delete_error_message', 'This account has been locked, please unlock the account to regain full functionality.')); ?>'))
            {
                return false;
            }
<?php elseif (corefunctions::getUsersAccountLockStatus($Auth->id) == 0): ?>
            if (confirm('<?php echo str_replace('\'', '', t('are_you_sure_you_want_to_remove_this_folder_inc_files', 'Are you sure you want to remove this folder? Any files within the folder will also be removed.')); ?>'))
            {
                deleteFolder(folderId);
            }
<?php endif; ?>
        return false;
    }

    function deleteFolder(folderId)
    {
        $.ajax({
            dataType: "json",
            url: "<?php echo CORE_AJAX_WEB_ROOT; ?>/_account_delete_folder.ajax.php",
            data: {folderId: folderId},
            success: function (data) {
                if (data.error == true)
                {
                    showErrorNotification('Error', data.msg);
                } else
                {
                    // refresh treeview
                    showSuccessNotification('Success', data.msg);
                    refreshFolderListing(false);
                    refreshFileListing();
                }
            }
        });
    }

    function confirmDeleteFolder(folderId)
    {
        // only allow actual sub folders
        if (isPositiveInteger(folderId) == false)
        {
            return false;
        }
<?php if (corefunctions::getUsersAccountLockStatus($Auth->id) == 1): ?>
            if (alert('<?php echo str_replace('\'', '', t('account_locked_folder_delete_error_message', 'This account has been locked, please unlock the account to regain full functionality.')); ?>'))
            {
                return false;
            }
<?php elseif (corefunctions::getUsersAccountLockStatus($Auth->id) == 0): ?>
            if (confirm('<?php echo str_replace('\'', '', t('are_you_sure_you_want_to_remove_this_folder_inc_files', 'Are you sure you want to remove this folder? Any files within the folder will also be removed.')); ?>'))
            {
                deleteFolder(folderId);
            }
<?php endif; ?>
        return false;
    }

    function deleteFolder(folderId)
    {
        $.ajax({
            dataType: "json",
            url: "<?php echo CORE_AJAX_WEB_ROOT; ?>/_account_delete_folder.ajax.php",
            data: {folderId: folderId},
            success: function (data) {
                if (data.error == true)
                {
                    showErrorNotification('Error', data.msg);
                } else
                {
                    // refresh treeview
                    showSuccessNotification('Success', data.msg);
                    refreshFolderListing(false);
                    refreshFileListing();
                }
            }
        });
    }

    function confirmEmptyTrash()
    {
        if (confirm('<?php echo str_replace('\'', '', t('are_you_sure_you_want_to_empty_the_trash', 'Are you sure you want to empty the trash can? Any statistics and other file information will be permanently deleted.')); ?>'))
        {
            emptyTrash();
        }

        return false;
    }

    function emptyTrash()
    {
        $.ajax({
            dataType: "json",
            url: "<?php echo CORE_AJAX_WEB_ROOT; ?>/_account_empty_trash.ajax.php",
            success: function (data) {
                if (data.error == true)
                {
                    alert(data.msg);
                } else
                {
                    // reload file listing
                    loadFiles();

                    // reload stats
                    updateStatsViaAjax();
                }
            }
        });
    }

    var hideLoader = false;
    function loadFiles()
    {
        hideLoader = false;
        setLoaderImage();

        // get variables
        folderId = getCurrentFolderId();
        filterText = $('#filterText').val();
        filterUploadedDateRange = $('#filterUploadedDateRange').val();
        filterOrderBy = $('#filterOrderBy').val();

        if (folderId == -1)
        {
            $("#folderTreeview").jstree("open_node", $('#-1'));
        }

        // reload file listing
        $('#fileManager').load("<?php echo WEB_ROOT; ?>/ajax/_account_home_v2_file_listing.ajax.php", {nodeId: folderId, filterText: filterText, filterUploadedDateRange: filterUploadedDateRange, filterOrderBy: filterOrderBy, pageStart: pageStart, perPage: perPage}, function (data) {
            // if there is zero results on the current page yet we are on a subpage, resend request from page zero
            if (pageStart > 0)
            {
                rspCurrentStart = parseInt($('#rspCurrentStart').val());
                rspTotalResults = parseInt($('#rspTotalResults').val());
                if (rspCurrentStart >= rspTotalResults)
                {
                    resetStartPoint();
                    loadFiles();

                    return;
                }
            }
            // toggle trash button on toolbar
            folderStatus = $('#rspFolderStatus').val();
            if (folderStatus == 'trash') {
                $('#uploadFileLink').hide();
                $('#emptyTrashLink').show();
            } else {
                $('#emptyTrashLink').hide();
                $('#uploadFileLink').show();
            }

            // ensure any selected icons are reselected
            hideLoader = true;
            setFolderStatusText();
            highlightSelected();
            updatePaging();
            updateActiveFilters();
            setupFileDragSelect();
            reloadDragItems();
            assignLiOnClick();
            pageTitle = $('#rspPageTitle').val();
            setPageTitle(pageTitle);

<?php if (isset($_REQUEST['upload'])): ?>
                if (inFileManager() == true)
                {
                    if (uploaderShown == false)
                    {
                        uploaderShown = true;
                        showUploaderPopup();
                    }
                }
<?php endif; ?>

            window.history.pushState({"html": $('#fileManagerContainer').html(), "pageTitle": pageTitle}, "", "account_home.html");
        });
    }

    // for browser history
    window.onpopstate = function (e) {
        if (e.state)
        {
            if ((typeof (e.state.html) != 'undefined') && (e.state.html != null))
            {
                $('#fileManagerContainer').html(e.state.html);
                setPageTitle(e.state.pageTitle);
                pageStart = $('#rspCurrentStart').val();
                if(typeof($('#nodeId')) != 'undefined') {
                    setCurrentFolderId($('#nodeId').val());
                }
                setFolderStatusText();
                highlightSelected();
                updatePaging();
                updateActiveFilters();
                setupFileDragSelect();
                reloadDragItems();
                assignLiOnClick();
            }
        }
    };

    function setPageTitle(pageTitle)
    {
        document.title = pageTitle + " - <?php echo validation::safeOutputToScreen(str_replace(array("\""), "'", SITE_CONFIG_SITE_NAME)); ?>";
    }

    function updateActiveFilters()
    {
        if ($('#nodeId').val() == 'recent')
        {
            $('#filterOrderBy').prop('disabled', 'disabled');
        } else
        {
            $('#filterOrderBy').prop('disabled', false);
        }
    }

    function setFolderStatusText()
    {
        totalFiles = $('#rspFolderTotalFiles').val();
        totalFileSize = $('#rspFolderTotalSize').val();

        statusText = totalFiles + ' <?php echo t('file', 'file'); ?>';
        if (totalFiles != 1)
        {
            statusText = totalFiles + ' <?php echo t('files', 'files'); ?>';
        }
        if (totalFileSize > 0)
        {
            statusText += '&nbsp;&nbsp;(' + bytesToSize(totalFileSize, 2) + ')';
        }

        $('#totalFilesText').html(statusText);
    }

    function setLoaderImage()
    {
        // introduce delay to only show on slower connections, restricts flickering
        setTimeout(function () {
            if (hideLoader == false)
            {
                $('#fileManager').html('<div class="loader">Loading...</div>');
            }
        }, 500);
    }

    function dblClickFile(fileId)
    {

    }

    function assignLiOnClick()
    {
        unbindLiOnClick();
        $(".fileManager .fileIconLi a.fileDownload").click(function (e) {
            e.stopPropagation();
            liElement = $(this).parents('.fileIconLi');
            return showFileMenu(liElement, e);
        });
        $(".fileManager .folderIconLi a.fileDownload").click(function (e) {
            e.stopPropagation();
            liElement = $(this).parents('.folderIconLi');
            return showFolderMenu(liElement, e);
        });
        $(".fileManager .fileIconLi").click(function (e) {
            e.stopPropagation();
            fileId = $(this).attr('fileId');
            selectFile(fileId);
        });
        $(".fileManager .folderIconLi").click(function (e) {
            e.stopPropagation();
            folderId = $(this).attr('folderId');
            selectFolder(folderId);
        });
        assignLiRightClick();
    }

    function unbindLiOnClick()
    {
        $(".fileManager .fileIconLi").unbind('click');
        $(".fileManager .folderIconLi").unbind('click');
        unbindLiRightClick();
    }

    function clearExistingHoverFileItem()
    {
        $('.hoverItem').removeClass('hoverItem');
    }

    function hoverFileItem(ele)
    {
        clearExistingHoverFileItem();
        $(ele).addClass('hoverItem');
    }

    function showFileMenu(liEle, clickEvent)
    {
        clickEvent.stopPropagation();
        hideOpenContextMenus();
        hoverFileItem(liEle);
        fileId = $(liEle).attr('fileId');
        downloadUrl = $(liEle).attr('dtfullurl');
        statsUrl = $(liEle).attr('dtstatsurl');
        isDeleted = $(liEle).hasClass('fileDeletedLi');
        fileName = $(liEle).attr('dtfilename');
        extraMenuItems = $(liEle).attr('dtextramenuitems');
        var items = {
            "Stats": {
                "label": "<?php echo UCWords(t('account_file_details_stats', 'Stats')); ?>",
                "icon": "glyphicon glyphicon-stats",
                "action": function (obj) {
                    showStatsPopup(fileId);
                }
            },
            "Select": {
                "label": "<?php echo UCWords(t('account_file_details_select_file', 'Select File')); ?> ",
                "icon": "glyphicon glyphicon-check",
                "action": function (obj) {
                    selectFile(fileId, true);
                }
            },
            "Restore": {
                "label": "<?php echo t('restore', 'Restore'); ?>",
                "icon": "glyphicon glyphicon-export",
                "separator_after": false,
                "action": function (obj) {
                    selectFile(fileId, true);
                    restoreItems();
                }
            },
            "Delete": {
                "label": "<?php echo t('permanently_delete', 'Permanently Delete'); ?>",
                "icon": "glyphicon glyphicon-remove",
                "separator_after": false,
                "action": function (obj) {
                    selectFile(fileId, true);
                    deleteFiles();
                }
            }
        }

        if (isDeleted == false)
        {
            var items = {};

            // replace any items for overwriting (plugins)
            if (extraMenuItems.length > 0)
            {
                items = JSON.parse(extraMenuItems);
                for (i in items)
                {
                    // setup click action on menu item
                    eval("items['" + i + "']['action'] = " + items[i]['action']);
                }
            }

            // default menu items
            items["Download"] = {
                "label": "<?php echo UCWords(t('account_file_details_download', 'Download')); ?> " + fileName,
                "icon": "la la-download",
				"separator_after": false,
                "action": function (obj) {
                    openUrl('<?php echo CORE_PAGE_WEB_ROOT; ?>/account_home_v2_direct_download.php?fileId=' + fileId);
                }
            };

			items["Information"] = {
				"label": "Information",
				"icon": "la la-info",
				"action": function (obj) {
					showFileInformation(fileId);
				}
			};

            items["Edit"] = {
                "label": "<?php echo UCWords(t('account_file_details_edit_file', 'Edit File')); ?>",
                "icon": "la la-pencil-square",
                "action": function (obj) {
                    showEditFileForm(fileId);
                }
            };

            items["Links"] = {
                "label": "<?php echo UCWords(t('file_manager_links', 'Links')); ?>",
                "icon": "la la-link",
                "action": function (obj) {
                    selectFile(fileId, true);
                    viewFileLinks();
                    // clear selected if only 1
                    if (countSelected() == 1)
                    {
                        clearSelectedItems();
                    }
                }
            };

			items["More"] = {
				"label": "More",
				"icon": "la la-ellipsis-h",
				"submenu":  {
					'copy': {
                        "label": "<?php echo t('copy_url_to_clipboard', 'Copy Url to Clipboard'); ?>",
				        "icon": "la la-clipboard",
						"extra": "#copy"+fileId,
				        "separator_after": false,
				        "action": function (obj) {
					    selectFile(fileId, true);
					    fileUrlText = '';
					    for (i in selectedItems)
					    {
					    	fileUrlText += selectedItems[i][3] + "<br/>";
					    }
					    $('#clipboard-placeholder').html(fileUrlText);
					    copyToClipboard('.fileMenuItem'+fileId);
				        }
                    },
					'duplicate': {
					    "label": "<?php echo UCWords(t('account_file_details_create_copy', 'Create Copy')); ?>",
				        "icon": "la la-copy",
				        "action": function (obj) {
					        selectFile(fileId, true);
					        duplicateFiles();
				        }
					},
					'send': {
						"label": "Send Via Email",
						"icon": "la la-envelope",
						"action": function(obj) {
					        sendEmail(fileId);
				        }
					},
					'stats': {
					    "label": "<?php echo UCWords(t('account_file_details_stats', 'Stats')); ?>",
				        "icon": "la la-bar-chart",
				        "action": function(obj) {
					        showStatsPopup(fileId);
				        }
					}

				}
			};

            items["Delete"] = {
                "label": "<?php echo UCWords(t('account_file_details_delete', 'Delete')); ?>",
                "icon": "la la-trash",
                "action": function (obj) {
                    selectFile(fileId, true);
                    trashFiles();
                }
            };

            // replace any items for overwriting
            for (i in extraMenuItems)
            {
                if (typeof (items[i]) != 'undefined')
                {
                    items[i] = extraMenuItems[i];
                }
            }
        }
        $.vakata.context.show(items, $(liEle), clickEvent.pageX, clickEvent.pageY, liEle);
        return false;
    }

    function showFolderMenu(liEle, clickEvent)
    {
        clickEvent.stopPropagation();
        var folderId = $(liEle).attr('folderId');
        var folderName = $(liEle).attr('dtfoldername');
        var isDeleted = $(liEle).hasClass('folderDeletedLi');
        if(isDeleted == false) {
            var items = {
                "Upload": {
                    "label": "<?php echo t('upload_to', 'Upload to'); ?> " + folderName,
                    "icon": "la la-upload",
                    "separator_after": false,
                    "action": function (obj) {
                        uploadFiles(folderId);
                    }
                },
                "Add": {
                    "label": "<?php echo t('add_sub_folder', 'Add Sub Folder'); ?>",
                    "icon": "la la-folder",
                    "action": function (obj) {
                        showAddFolderForm(folderId);
                    }
                },
                "Edit": {
                    "label": "<?php echo t('edit_folder', 'Edit'); ?>",
                    "icon": "la la-pencil-square",
                    "action": function (obj) {
                        showAddFolderForm(null, folderId);
                    }
                },
                "Download": {
                    "label": "<?php echo t('download_all_files', 'Download All Files (Zip)'); ?>",
                    "icon": "la la-download",
                    "separator_before": false,
                    "action": function (obj) {
                        downloadAllFilesFromFolder(folderId);
                    }
                },
                "Copy": {
                    "label": "<?php echo t('copy_url_to_clipboard', 'Copy Url to Clipboard'); ?>",
                    "icon": "la la-link",
                    "classname": "folderMenuItem" + folderId,
                    "action": function (obj) {
                        $('#clipboard-placeholder').html($('#folderItem' + folderId).attr('sharing-url'));
                        copyToClipboard('.folderMenuItem' + folderId);
                    }
                },
                "Share": {
                    "label": "<?php echo t('share_folder', 'Share Folder'); ?>",
                    "icon": "la la-share-alt",
                    "action": function (obj) {
                        showFolderSharingForm(folderId);
                    }
                },
				 "Delete": {
                    "label": "<?php echo t('delete_folder', 'Delete'); ?>",
                    "icon": "la la-trash",
                    "action": function (obj) {
                        selectFolder(folderId, true);
                        trashFiles();
                    }
                },
            };
        }
        else {
            var items = {
                "Select": {
                    "label": "<?php echo UCWords(t('account_file_details_select_folder', 'Select Folder')); ?> ",
                    "icon": "glyphicon glyphicon-check",
                    "action": function (obj) {
                        selectFolder(folderId, true);
                    }
                },
                "Restore": {
                    "label": "<?php echo t('restore', 'Restore'); ?>",
                    "icon": "glyphicon glyphicon-export",
                    "separator_after": false,
                    "action": function (obj) {
                        selectFolder(folderId, true);
                        restoreItems();
                    }
                },
                "Delete": {
                    "label": "<?php echo t('permanently_delete', 'Permanently Delete'); ?>",
                    "icon": "la la-trash",
                    "separator_after": false,
                    "action": function (obj) {
                        selectFolder(folderId, true);
                        deleteFiles();
                    }
                }
            }
        }

        $.vakata.context.show(items, $(liEle), clickEvent.pageX - 15, clickEvent.pageY - 8, liEle);
        return false;
    }

    function assignLiRightClick()
    {
        $(".fileManager .fileIconLi").bind('contextmenu', function (e) {
            return showFileMenu(this, e);
        });

        $(".fileManager .folderIconLi").bind('contextmenu', function (e) {
            return showFolderMenu(this, e);
        });

        $(".file-manager-container").bind('contextmenu', function (e) {
            e.stopPropagation();
            hideOpenContextMenus();
            var items = {
                "Upload": {
                    "label": "<?php echo UCWords(t('upload_files', 'Upload Files')); ?>",
                    "icon": "la la-upload",
					"separator_after": false,
                    "action": function (obj) {
                        uploadFiles();
                    }
                },
                "Add": {
                    "label": "<?php echo UCWords(t('add_sub_folder', 'Add Sub Folder')); ?>",
                   "icon": "la la-folder",
					"separator_after": false,
                    "action": function (obj) {
                        showAddFolderForm();
                    }
                },
                "SelectAll": {
                    "label": "<?php echo UCWords(t('account_file_details_select_all_items', 'Select All Items')); ?>",
                    "icon": "la la-check-square",
                    "action": function (obj) {
                        selectAllItems();
                    }
                },
                "ClearAll": {
                    "label": "<?php echo UCWords(t('account_file_details_clear_selected', 'Clear Selected')); ?>",
                    "icon": "la la-minus-square",
                    "action": function (obj) {
                        clearSelectedItems();
                    }
                }
            };
            $.vakata.context.show(items, $(this), e.pageX, e.pageY, this);
            return false;
        });

        // enable closing of context menus on left click
        $("body").click(function () {
            hideOpenContextMenus();
        });
    }

    function hideOpenContextMenus()
    {
        // hide any exiting context menus
        $.vakata.context.hide();
        $('[data-toggle="dropdown"]').parent().removeClass('open');
        clearExistingHoverFileItem();
    }

    function unbindLiRightClick()
    {
        $(".fileManager .fileIconLi").unbind('contextmenu');
        $(".fileManager .folderIconLi").unbind('contextmenu');
        $(".fileManager").unbind('contextmenu');
    }

    function selectAllItems() {
        selectAllFolders();
        selectAllFiles();
    }

    function selectAllFiles()
    {
        $('.fileIconLi').each(function () {
            selectFile($(this).attr('fileId'), true);
        });
    }

    function selectAllFolders()
    {
        $('.folderIconLi').each(function () {
            selectFolder($(this).attr('folderId'), true);
        });
    }

    function getAllSelectedFileIds() {
        fileIds = [];
        for (i in selectedFiles) {
            fileIds.push(i.replace('k', ''));
        }

        return fileIds;
    }

    function getAllSelectedFolderIds() {
        folderIds = [];
        for (i in selectedFolders) {
            folderIds.push(i.replace('k', ''));
        }

        return folderIds;
    }

    function selectFile(fileId, onlySelectOn)
    {
        if (typeof (onlySelectOn) == "undefined")
        {
            onlySelectOn = false;
        }

        // clear any selected if ctrl key not pressed
        if ((ctrlPressed == false) && (onlySelectOn == false))
        {
            showFileInformation(fileId);

            return false;
        }

        elementId = 'fileItem' + fileId;
        if (($('.' + elementId).hasClass('selected')) && (onlySelectOn == false))
        {
            $('.' + elementId).removeClass('selected');
            if (typeof (selectedFiles['k' + fileId]) != 'undefined')
            {
                delete selectedFiles['k' + fileId];
            }
        } else
        {
            $('.' + elementId).addClass('selected');
            if ($('.' + elementId).hasClass('selected'))
            {
                selectedFiles['k' + fileId] = [fileId, $('.' + elementId).attr('dttitle'), $('.' + elementId).attr('dtsizeraw'), $('.' + elementId).attr('dtfullurl'), $('.' + elementId).attr('dturlhtmlcode'), $('.' + elementId).attr('dturlbbcode')];
            }
        }

        $('.files-info').removeClass('hidden');
		updateSelectedItemsStatusText();
        updateFileActionButtons();
    }

    function selectFolder(folderId, onlySelectOn)
    {
        if (typeof (onlySelectOn) == "undefined")
        {
            onlySelectOn = false;
        }

        // clear any selected if ctrl key not pressed
        if ((ctrlPressed == false) && (onlySelectOn == false))
        {
            loadFolderFiles(folderId);

            return false;
        }

        elementId = 'folderItem' + folderId;
        if (($('.' + elementId).hasClass('selected')) && (onlySelectOn == false))
        {
            $('.' + elementId).removeClass('selected');
            if (typeof (selectedFolders['k' + folderId]) != 'undefined')
            {
                delete selectedFolders['k' + folderId];
            }
        } else
        {
            $('.' + elementId).addClass('selected');
            if ($('.' + elementId).hasClass('selected'))
            {
                selectedFolders['k' + folderId] = [folderId];
            }
        }

        $('.files-info').removeClass('hidden');
		updateSelectedItemsStatusText();
        updateFileActionButtons();
    }

    function clearSelectedItems()
    {
        $('.files-info').animate({'margin-right': '-250' , 'display': 'none'});
		selectedFiles = [];
        selectedFolders = [];
        $('.selected').removeClass('selected');
		$('.files-info').addClass('hidden');
        updateSelectedItemsStatusText();
        updateFileActionButtons();
    }

    function highlightSelected()
    {
        for (i in selectedFiles)
        {
            elementId = 'fileItem' + selectedFiles[i][0];
            $('.' + elementId).addClass('selected');
        }
    }

    function countSelected()
    {
        count = 0;
        for (i in selectedFiles) {
            count = count + 1;
        }

        for (i in selectedFolders) {
            count = count + 1;
        }

        return count;
    }

    function getSizeSelected()
    {
        total = 0;
        for (i in selectedFiles) {
            itemSize = parseInt(selectedFiles[i][2]);
            total = total + itemSize;
        }

        return total;
    }

    function updateSelectedItemsStatusText()
    {
        count = countSelected();
        if (count > 1)
        {
            totalFilesize = getSizeSelected();
            updateStatusText(count + ' <?php echo t('selected_items', 'selected items'); ?> (' + bytesToSize(totalFilesize, 2) + ')');
        } else if (count == 1)
        {
            for (i in selectedFiles)
            {
                itemId = selectedFiles[i][0];
                itemTitle = selectedFiles[i][1];
                itemSize = selectedFiles[i][2];
                updateStatusText(itemTitle + ' (' + bytesToSize(itemSize, 2) + ')');
            }
        } else if (count == 0)
        {
            updateStatusText(null);
        }
    }

    function updateStatusText(text)
    {
        if (text != null)
        {
            text = '<i class="la la-file"></i> ' + text;
        }

        $('#statusText').html(text);
    }

    function toggleViewType()
    {
        if ($('#fileManager').hasClass('fileManagerList'))
        {
            $('#fileManager').removeClass('fileManagerList');
			$('#fileManagerWrapper').removeClass('list');
            $('#fileManager').addClass('fileManagerIcon');
            $('#viewTypeText').html('<i class="la la-th-list"></i>');
        }
        else
        {
            $('#fileManager').addClass('fileManagerList');
			$('#fileManagerWrapper').addClass('list');
            $('#fileManager').removeClass('fileManagerIcon');
            $('#viewTypeText').html('<i class="la la-th"></i>');
        }
    }

    var ctrlPressed = false;
    $(window).keydown(function (evt) {
        if (evt.which == 17) {
            ctrlPressed = true;
        }
    }).keyup(function (evt) {
        if (evt.which == 17) {
            ctrlPressed = false;
        }
    });

    $(window).keydown(function (evt) {
        if (evt.which == 65) {
            if (ctrlPressed == true)
            {
                selectAllItems();
                return false;
            }
        }
    })

    function updateFileActionButtons()
    {
        totalSelected = countSelected();
        if (totalSelected > 0)
        {
            $('.files-info').animate({'margin-right': '0' , 'display': 'block'});

        }
        else
        {
            $('.files-info').animate({'margin-right': '-250' , 'display': 'none'});
        }
    }

    function viewFileLinks()
    {
        count = countSelected();
        if (count > 0)
        {
            fileUrlText = '';
            htmlUrlText = '';
            bbCodeUrlText = '';
            for (i in selectedFiles)
            {
                fileUrlText += selectedFiles[i][3] + "<br/>";
                htmlUrlText += selectedFiles[i][4] + "&lt;br/&gt;<br/>";
                bbCodeUrlText += selectedFiles[i][5] + "<br/>";
            }

            $('#popupContentUrls').html(fileUrlText);
            $('#popupContentHTMLCode').html(htmlUrlText);
            $('#popupContentBBCode').html(bbCodeUrlText);

            jQuery('#fileLinksModal').modal('show', {backdrop: 'static'}).on('shown.bs.modal');
        }
    }

    function showLightboxNotice()
    {
        jQuery('#generalModal').modal('show', {backdrop: 'static'}).on('shown.bs.modal', function () {
            $('.general-modal .modal-body').html($('#filePopupContentWrapperNotice').html());
        });
    }

    function showFileInformation(fileId)
    {
        // hide any context menus
        hideOpenContextMenus();

        // load popup
        showLoaderModal();
        jQuery('#fileDetailsModal .modal-content').load("<?php echo WEB_ROOT; ?>/ajax/_account_file_details.ajax.php", {u: fileId}, function () {
            reselectFileInfoTab();
            trackSelectedFileInfoTab();
            hideLoaderModal();
            jQuery('#fileDetailsModal').modal('show', {backdrop: 'static'}).on('shown.bs.modal', function () {
                addthis.toolbox('.addthis_toolbox');
            });
        });
    }

	function showFileLinks(fileId)
    {
        // hide any context menus
        hideOpenContextMenus();

        // load popup
        showLoaderModal();
        jQuery('#fileLinks .modal-content').load("<?php echo WEB_ROOT; ?>/ajax/_account_file_links.ajax.php", {u: fileId}, function() {
			reselectFileInfoTab();
			trackSelectedFileInfoTab();
            hideLoaderModal();
            jQuery('#fileLinks').modal('show', {backdrop: 'static'}).on('shown.bs.modal', function() {
                addthis.toolbox('.addthis_toolbox');
            });
        });
    }
	function sendEmail(fileId)
    {
        // hide any context menus
        hideOpenContextMenus();

        // load popup
        showLoaderModal();
        jQuery('#sendEmail .modal-content').load("<?php echo WEB_ROOT; ?>/ajax/_send_file_email.ajax.php", {u: fileId}, function() {
            hideLoaderModal();
            jQuery('#sendEmail').modal('show', {backdrop: 'static'}).on('shown.bs.modal', function() {
                addthis.toolbox('.addthis_toolbox');
            });
        });
    }

    function reselectFileInfoTab()
    {
        $('a[data-toggle="tab"]:eq(' + filePopupSelectedTab + ')').tab('show');
    }

    function trackSelectedFileInfoTab()
    {
        $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
            // show selected tab / active
            filePopupSelectedTab = $('a[data-toggle="tab"]').index($(e.target));
        });
    }

    function refreshFileListing()
    {
        hideLoader = false;
        setLoaderImage();
        loadFiles();
    }

    function updatePaging()
    {
        totalResults = parseInt($('#rspTotalResults').val());
        totalPerPage = parseInt($('#rspTotalPerPage').val());
        currentStart = parseInt($('#rspCurrentStart').val());

        // setup paging
        pagingHtml = '';
        if (totalResults > 0)
        {
            pagingHtml += '<ul class="pagination">';
            pagingHtml += '<li><a href="#" id="previousLink" onClick="loadPreviousPage(); return false;" class="previous"><i class="la la-chevron-left"></i> </a></li>';
            totalPages = Math.ceil(totalResults / totalPerPage);
            overallPages = totalPages;
            if (totalPages > 11)
            {
                totalPages = 11;
            }
            r = 0;
            if (pageStart > 0)
            {
                r = (pageStart / totalPerPage) - 5;
                if (r < 0)
                {
                    r = 0;
                }
            }
            endPoint = (r + totalPages);
            while (r < endPoint)
            {
                pageNum = r + 1;
                if (pageNum <= overallPages)
                {
                    pagingHtml += '<li';
                    if (pageStart == (r * totalPerPage))
                    {
                        pagingHtml += ' class="active"';
                    }
                    pagingHtml += '><a href="#" onClick="loadPage(' + (r * totalPerPage) + '); return false;">' + pageNum + '</a></li>';
                }
                r++;
            }
            pagingHtml += '<li><a href="#" id="nextLink" onClick="loadNextPage(); return false;" class="next"> <i class="la la-chevron-right"></i></a></li>';
            pagingHtml += '</ul>';
        }
        $('#pagination').html(pagingHtml);

        if (totalResults > 0)
        {
            // set disabled paging links
            $('#previousLink').parent().removeClass('disabled');
            if (currentStart == 0)
            {
                $('#previousLink').parent().addClass('disabled');
            }

            $('#nextLink').parent().removeClass('disabled');
            if ((currentStart + perPage) >= totalResults)
            {
                $('#nextLink').parent().addClass('disabled');
            }
        }
    }

    function loadPreviousPage()
    {
        currentStart = parseInt($('#rspCurrentStart').val());
        if (currentStart > 0)
        {
            pageStart = pageStart - perPage;
            refreshFileListing();
        }
    }

    function loadNextPage()
    {
        totalResults = parseInt($('#rspTotalResults').val());
        if ((pageStart + perPage) < totalResults)
        {
            pageStart = pageStart + perPage;
            refreshFileListing();
        }
    }

    function loadPage(startPos)
    {
        $('html, body').animate({
            scrollTop: $("body").offset().top
        }, 700);
        pageStart = startPos;
        refreshFileListing();
    }

    function doFilter(fromFilterLocal)
    {
        if (typeof (fromFilterLocal) == 'undefined')
        {
            fromFilterLocal = false;
        }

        fromFilterModal = fromFilterLocal;
        resetStartPoint();

        // if we need to filter all folders
        if (($('#filterFolderAll').is(":checked")) && (fromFilterModal == true))
        {
            $('#nodeId').val('all');
        }

        refreshFolderBreadcrumbs();
        loadFiles();
    }

    function deleteFileFromDetailPopup(fileId)
    {
        selectFile(fileId, true);
        trashFiles(true);
    }

    function trashFiles(fromFileDetails)
    {
        if (typeof (fromFileDetails) == 'undefined')
        {
            fromFileDetails = false;
        }

        if (countSelected() > 0)
        {
<?php if (corefunctions::getUsersAccountLockStatus($Auth->id) == 0): ?>
                text = "<?php echo str_replace('"', '\"', t('file_manager_are_you_sure_you_want_to_delete_x_items', 'Are you sure you want to remove the selected [[[TOTAL_ITEMS]]] item(s)?')); ?>";
                text = text.replace('[[[TOTAL_ITEMS]]]', countSelected());

                if (confirm(text))
                {
                    trashFilesConfirm(fromFileDetails);
                } else
                {
                    // clear selected if only 1
                    if (countSelected() == 1)
                    {
                        clearSelectedItems();
                    }
                }
<?php elseif (corefunctions::getUsersAccountLockStatus($Auth->id) == 1): ?>
                text = "<?php echo t('account_locked_folder_edit_error_message', 'This account has been locked, please unlock the account to regain full functionality.'); ?>";
                if (alert(text))
                {
                    return false;
                }
<?php endif; ?>
        }

        return false;
    }

    var bulkError = '';
    var bulkSuccess = '';
    var totalDone = 0;
    function addBulkError(x)
    {
        bulkError += x;
    }
    function getBulkError(x)
    {
        return bulkError;
    }
    function addBulkSuccess(x)
    {
        bulkSuccess += x;
    }
    function getBulkSuccess(x)
    {
        return bulkSuccess;
    }
    function clearBulkResponses()
    {
        bulkError = '';
        bulkSuccess = '';
    }
    function trashFilesConfirm(fromFileDetails)
    {
        if (typeof (fromFileDetails) == 'undefined')
        {
            fromFileDetails = false;
        }

        // clear file details popup
        if (fromFileDetails == true)
        {
            jQuery('#fileDetailsModal').modal('hide');
        }

        // show loader
        showLoaderModal(0);

        // prepare file ids
        fileIds = getAllSelectedFileIds();
        folderIds = getAllSelectedFolderIds();

        // get server list first
        $.ajax({
            type: "POST",
            url: "<?php echo CORE_AJAX_WEB_ROOT; ?>/_file_manage_bulk_trash.ajax.php",
            data: {fileIds: fileIds, folderIds: folderIds},
            dataType: 'json',
            success: function (json) {
                if (json.error == true)
                {
                    // hide loader
                    hideLoaderModal();
                    $('#filePopupContentNotice').html(json.msg);
                    showLightboxNotice();
                } else
                {
                    addBulkSuccess(json.msg);
                    finishBulkProcess();
                }

            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                $('#popupContentNotice').html('Failed connecting to server to get the list of servers, please try again later.');
                showLightboxNotice();
            }
        });
    }

    function finishBulkProcess()
    {
        // get final response
        bulkError = getBulkError();
        bulkSuccess = getBulkSuccess();

        // compile result
        if (bulkError.length > 0)
        {
            // hide loader
            hideLoaderModal();
            $('#filePopupContentNotice').html(bulkError + bulkSuccess);
            showLightboxNotice();
        } else
        {
            // hide loader
            hideLoaderModal();
        }
        clearBulkResponses();
        clearSelectedItems();
        refreshFileListing();
        refreshFolderListing(false);

        // reload stats
        updateStatsViaAjax();
    }

    function deleteFiles()
    {
        if (countSelected() > 0)
        {
<?php if (corefunctions::getUsersAccountLockStatus($Auth->id) == 0): ?>
                text = "<?php echo str_replace('"', '\"', t('file_manager_are_you_sure_you_want_to_permanently_x_items', 'Are you sure you want to permanently delete the selected [[[TOTAL_ITEMS]]] item(s)?')); ?>";
                text = text.replace('[[[TOTAL_ITEMS]]]', countSelected());

                if (confirm(text))
                {
                    deleteFilesConfirm();
                }
                else
                {
                    // clear selected if only 1
                    if (countSelected() == 1)
                    {
                        clearSelectedItems();
                    }
                }
<?php elseif (corefunctions::getUsersAccountLockStatus($Auth->id) == 1): ?>
                text = "<?php echo t('account_locked_folder_edit_error_message', 'This account has been locked, please unlock the account to regain full functionality.'); ?>";
                if (alert(text))
                {
                    return false;
                }
<?php endif; ?>
        }

        return false;
    }

    function restoreItems() {
        if (countSelected() == 0) {
            alert('Please select some items to restore.');
            return false;
        }

        showLoaderModal();

        // prepare file ids
        fileIds = getAllSelectedFileIds();
        folderIds = getAllSelectedFolderIds();

        jQuery('#addEditFolderModal .modal-content').load("<?php echo WEB_ROOT; ?>/ajax/_account_restore_from_trash.ajax.php", {fileIds: fileIds, folderIds: folderIds}, function () {
            hideLoaderModal();
            jQuery('#addEditFolderModal').modal('show', {backdrop: 'static'}).on('shown.bs.modal', function () {
                $('#addEditFolderModal input').first().focus();
            });
        });
    }

    function deleteFilesConfirm()
    {
        // show loader
        showLoaderModal(0);

        // prepare file ids
        fileIds = getAllSelectedFileIds();
        folderIds = getAllSelectedFolderIds();

        // trigger delete
        $.ajax({
            type: "POST",
            url: "<?php echo CORE_AJAX_WEB_ROOT; ?>/_file_manage_bulk_delete.ajax.php",
            data: {fileIds: fileIds, folderIds: folderIds},
            dataType: 'json',
            success: function (json) {
                if (json.error == true)
                {
                    // hide loader
                    hideLoaderModal();
                    $('#filePopupContentNotice').html(json.msg);
                    showLightboxNotice();
                }
                else
                {
                    addBulkSuccess(json.msg);
                    finishBulkProcess();
                }

            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                $('#popupContentNotice').html('Failed connecting to server to delete items, please try again later.');
                showLightboxNotice();
            }
        });
    }

    function selectPreviousFile()
    {
        // only continue if popup showing
        if (jQuery('#fileDetailsModal').data('bs.modal').isShown == true)
        {
            // get currently selected tab
            //fileDetailsSelectedTab = $('.file-details-modal .nav-tabs li.active').index();

            // get prev file id
            liItem = $('.fileItem' + fileId).prev('.fileIconLi');
            if (typeof ($(liItem).attr('fileid')) != 'undefined')
            {
                fileId = $(liItem).attr('fileid');
                selectFile(fileId);
            }
        }
    }

	function viewVideo(fileId)
    {
        // hide any context menus
        hideOpenContextMenus();

        // load popup
        showLoaderModal();
        jQuery('#video_preview').load("<?php echo WEB_ROOT; ?>/ajax/_viewVideo.ajax.php", {u: fileId}, function() {
            reselectFileInfoTab();
			trackSelectedFileInfoTab();
            hideLoaderModal();
            jQuery('#video_preview').modal('show', {backdrop: 'static'}).on('shown.bs.modal', function() {
                addthis.toolbox('.addthis_toolbox');
            });
        });
    }

    function selectNextFile()
    {
        // only continue if popup showing
        if (jQuery('#fileDetailsModal').data('bs.modal').isShown == true)
        {
            // get currently selected tab
            //fileDetailsSelectedTab = $('.file-details-modal .nav-tabs li.active').index();

            // get next file id
            liItem = $('.fileItem' + fileId).next('.fileIconLi');
            if (typeof ($(liItem).attr('fileid')) != 'undefined')
            {
                fileId = $(liItem).attr('fileid');
                selectFile(fileId);
            }
        }
    }

    function showUploaderPopup()
    {
        jQuery('#fileUploadWrapper').modal('show', {backdrop: 'static'}).on('shown.bs.modal', function () {
            saveAdditionalOptions(true);
        }).on('hidden.bs.modal', function () {
            checkShowUploadProgressWidget();
        });
    }

    function downloadAllFilesFromFolder(folderId)
    {
        // only allow actual sub folders
        if (isPositiveInteger(folderId) == false)
        {
            return false;
        }

        if (confirm("<?php echo t('account_home_are_you_sure_download_all_files', 'Are you sure you want to download all the files in this folder? This may take some time to complete.'); ?>"))
        {
            downloadAllFilesFromFolderConfirm(folderId);
        }

        return false;
    }

    function downloadAllFilesFromFolderConfirm(folderId)
    {
        jQuery('#downloadFolderModal').modal('show', {backdrop: 'static'}).on('shown.bs.modal', function () {
            $('.download-folder-modal .modal-body').html('<iframe src="<?php echo CORE_AJAX_WEB_ROOT; ?>/_account_home_v2_download_all_folder_files.ajax.php?folderId=' + folderId + '" style="zoom:0.60" width="99.6%" height="100%" frameborder="0"></iframe>');
        });
    }
</script>


<script>
    function updateSorting(key, label, ele)
    {
        $('#filterOrderBy').val(key);
        $('#filterButton').html(label);
        doFilter();
    }

    function showFilterModal()
    {
        jQuery('#filterModal').modal('show', {backdrop: 'static'}).on('shown.bs.modal', function () {
            $('#filterModal #filterFolderId').val($('#nodeId').val());
            $('#filterModal input').first().focus();
        });
    }

    function toggleFullScreenMode()
    {
        if ((document.fullScreenElement && document.fullScreenElement !== null) ||
                (!document.mozFullScreen && !document.webkitIsFullScreen)) {
            if (document.documentElement.requestFullScreen) {
                document.documentElement.requestFullScreen();
            } else if (document.documentElement.mozRequestFullScreen) {
                document.documentElement.mozRequestFullScreen();
            } else if (document.documentElement.webkitRequestFullScreen) {
                document.documentElement.webkitRequestFullScreen(Element.ALLOW_KEYBOARD_INPUT);
            }
        } else {
            if (document.cancelFullScreen) {
                document.cancelFullScreen();
            } else if (document.mozCancelFullScreen) {
                document.mozCancelFullScreen();
            } else if (document.webkitCancelFullScreen) {
                document.webkitCancelFullScreen();
            }
        }
    }

    function clearSearchFilters(doFilterLocal)
    {
        if (typeof (doFilterLocal) == 'undefined')
        {
            doFilterLocal = true;
        }

        $('#filterText').val('');
        $('#filterUploadedDateRange').val('');
        $('#filterUploadedDateRange').parent().find('.daterange span').html('<?php echo str_replace("'", "\'", t('file_manager_select_range', 'Select range...')); ?>');

        if (doFilterLocal == true)
        {
            doFilter();
        }
    }

    function showAddFolderForm(parentId, editFolderId)
    {
        // only allow actual sub folders on edit
        if ((typeof (editFolderId) != 'undefined') && (isPositiveInteger(editFolderId) == false))
        {
            return false;
        }

        showLoaderModal();
        if (typeof (parentId) == 'undefined')
        {
            parentId = $('#nodeId').val();
        }

        if (typeof (editFolderId) == 'undefined')
        {
            editFolderId = 0;
        }

        jQuery('#addEditFolderModal .modal-content').load("<?php echo WEB_ROOT; ?>/ajax/_account_add_edit_folder.ajax.php", {parentId: parentId, editFolderId: editFolderId}, function () {
            hideLoaderModal();
            jQuery('#addEditFolderModal').modal('show', {backdrop: 'static'}).on('shown.bs.modal', function () {
                $('#addEditFolderModal input').first().focus();
            });
        });
    }

    function showLinkSection(sectionId, ele)
    {
        $('.link-section').hide();
        $('#' + sectionId).show();
        $(ele).parent().children('.active').removeClass('active');
        $(ele).addClass('active');
        $('.file-links-wrapper .modal-header .modal-title').html($(ele).html());
    }

    function selectAllText(el)
    {
        if (typeof window.getSelection != "undefined" && typeof document.createRange != "undefined")
        {
            var range = document.createRange();
            range.selectNodeContents(el);
            var sel = window.getSelection();
            sel.removeAllRanges();
            sel.addRange(range);
        } else if (typeof document.selection != "undefined" && typeof document.body.createTextRange != "undefined")
        {
            var textRange = document.body.createTextRange();
            textRange.moveToElementText(el);
            textRange.select();
        }
    }

<?php
// load folder structure as array
$folderListing = fileFolder::loadAllActiveForSelect($Auth->id, '|||');
$folderListingArr = array();
foreach ($folderListing AS $k => $folderListingItem) {
    $folderListingArr[$k] = validation::safeOutputToScreen($folderListingItem);
}
$jsArray = json_encode($folderListing);
echo "var folderArray = " . $jsArray . ";\n";
?>
    function refreshFolderBreadcrumbs()
    {
        html = '';

        // add root
        html += '<li><a href="#" onClick="loadFolderFiles(\'-1\'); return false;"><i class="la la-folder"></i><?php echo t('your_uploads', 'Your Uploads'); ?></a></li>';

        if ($('#nodeId').val() != '-1')
        {
            if (typeof (folderArray[$('#nodeId').val()]) != 'undefined')
            {
                var breadcrumbItems = folderArray[$('#nodeId').val()].split('|||');
                total = breadcrumbItems.length;
                tracker = 1;
                pathSoFar = '';
                for (i in breadcrumbItems)
                {
                    pathSoFar += breadcrumbItems[i];
                    // for last item
                    if (total == tracker)
                    {
                        // add last item
                        html += '<li class="active">' + breadcrumbItems[i] + '</li>';
                    } else
                    {
                        // add item
                        html += '<li><a href="#" onClick="loadFolderFiles(\'' + lookupFolderIdBasedOnPath(pathSoFar) + '\'); return false;;">' + breadcrumbItems[i] + '</a></li>';
                    }
                    tracker++;
                    pathSoFar += '|||';
                }
            }

            if ($('#nodeId').val() == 'recent')
            {
                // add last item
                html += '<li class="active"><?php echo t('recent_uploads', 'Recent Uploads'); ?></li>';
            }

            if ($('#nodeId').val() == 'all')
            {
                // add last item
                html += '<li class="active"><?php echo t('all_files', 'All Files'); ?></li>';
            }

            if ($('#nodeId').val() == 'trash')
            {
                // add last item
                html += '<li class="active"><?php echo t('trash_can', 'Trash Can'); ?></li>';
            }
        }

        html += '<li id="totalFilesText" class="active">...</li>';

        $('#folderBreadcrumbs').html(html);
    }

    function lookupFolderIdBasedOnPath(path)
    {
        // lookup id
        for (a in folderArray)
        {
            if (path == folderArray[a])
            {
                return a;
            }
        }

        return -1;
    }

    function updatePerPage(key, label, ele)
    {
        $('#perPageElement').val(key);
        $('#perPageButton').html(' Per page ' + label);
        setPerPage();
    }

    function markInternalNotificationsRead()
    {
        $.ajax({
            dataType: "json",
            url: "<?php echo CORE_AJAX_WEB_ROOT; ?>/_account_internal_notification_mark_all_read.ajax.php",
            success: function (data) {
                $('.internal-notification .unread').addClass('read').removeClass('unread');
                $('.internal-notification .text-bold').removeClass('text-bold');
                $('.internal-notification .badge').hide();
                $('.internal-notification .unread-count').html('You have 0 new notifications.');
                $('.internal-notification .mark-read-link').hide();
            }
        });
    }

    function inFileManager()
    {
<?php if (defined('FROM_ACCOUNT_HOME')): ?>
            return true;
<?php else: ?>
            return false;
<?php endif; ?>
    }

    progressWidget = null;
    function showProgressWidget(intialText, title, complete)
    {
        if (inFileManager() == false)
        {
            return false;
        }

        if (progressWidget != null)
        {
            progressWidget.hide();
        }

        var opts = {
            "closeButton": false,
            "debug": false,
            "positionClass": "toast-bottom-right",
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "0",
            "extendedTimeOut": "0",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut",
            "onclick": function () {
                showUploaderPopup();
            }
        };

        if (complete == true)
        {
            progressWidget = toastr.success(intialText, title, opts);
        } else
        {
            progressWidget = toastr.info(intialText, title, opts);
        }
    }

    function updateProgressWidgetText(text)
    {
        if (inFileManager() == false)
        {
            return false;
        }

        if (progressWidget == null)
        {
            return false;
        }

        $(progressWidget).find('.toast-message').html(text);
    }

    function checkShowUploadProgressWidget()
    {
        if ((inFileManager() == true) && (uploadComplete == false))
        {
            showProgressWidget('<?php echo str_replace("'", "", t('file_manager_uploading', 'Uploading...')); ?>', '<?php echo str_replace("'", "", t('file_manager_upload_progress', 'Upload Progress:')); ?>', false);
        }
    }

    function checkShowUploadFinishedWidget()
    {
        if (inFileManager() == true)
        {
            showProgressWidget('<?php echo str_replace("'", "", t('file_manager_upload_complete_click_here_to_view', 'Upload complete. Click here to view links.')); ?>', '<?php echo str_replace("'", "", t('file_manager_upload_progress', 'Upload Progress:')); ?>', true);
        }
    }

    function triggerFileDownload(fileId)
    {
        openUrl("<?php echo CORE_PAGE_WEB_ROOT; ?>/account_home_v2_direct_download.php?fileId=" + fileId);
    }

    function openUrl(url)
    {
        if (uploadComplete == false)
        {
            window.open(url);
        } else
        {
            window.location = url;
        }
    }

    function showEditFileForm(fileId)
    {
        showLoaderModal();
        jQuery('#editFileModal .modal-content').load("<?php echo WEB_ROOT; ?>/ajax/_account_edit_file.ajax.php", {fileId: fileId}, function () {
            hideLoaderModal();
            jQuery('#editFileModal').modal('show', {backdrop: 'static'}).on('shown.bs.modal', function () {
                toggleFilePasswordField();
                $('#editFileModal input').first().focus();
            });
        });
    }

    function toggleFilePasswordField()
    {
        if ($('.edit-file-modal #enablePassword').is(':checked'))
        {
            $('.edit-file-modal #password').attr('READONLY', false);
        } else
        {
            $('.edit-file-modal #password').attr('READONLY', true);
        }
    }

    function toggleFolderPasswordField()
    {
        if ($('.edit-folder-modal #enablePassword').is(':checked'))
        {
            $('.edit-folder-modal #password').attr('READONLY', false);
        } else
        {
            $('.edit-folder-modal #password').attr('READONLY', true);
        }
    }

    function updateStatsViaAjax()
    {
        // first request stats via ajax
        $.ajax({
            dataType: "json",
            url: "<?php echo CORE_AJAX_WEB_ROOT; ?>/_account_get_account_file_stats.ajax.php",
            success: function (data) {
                updateOnScreenStats(data);
            }
        });
    }

    function updateJSFolderArray(lFolderArray)
    {
        // update list of folders for breadcrumbs
        folderArray = jQuery.parseJSON(lFolderArray);
    }

    function updateOnScreenStats(data)
    {
        // update list of folders for breadcrumbs
        updateJSFolderArray(data.folderArray);

        // update folder drop-down list in the popup uploader
        $("#upload_folder_id").html(data.folderSelectForUploader);

        // reselect selected items
        if (typeof (setUploadFolderId) === 'function')
        {
            setUploadFolderId($('#nodeId').val());
        }

        // update root folder stats
        if (data.totalRootFiles > 0)
        {
            $("#folderTreeview").jstree('set_text', '#-1', $('#-1').attr('original-text') + ' (' + data.totalRootFiles + ')');
        } else
        {
            $("#folderTreeview").jstree('set_text', '#-1', $('#-1').attr('original-text'));
        }

        // update trash folder stats
        if (data.totalTrashFiles > 0)
        {
            $("#folderTreeview").jstree('set_text', '#trash', $('#trash').attr('original-text') + ' (' + data.totalTrashFiles + ')');
        } else
        {
            $("#folderTreeview").jstree('set_text', '#trash', $('#trash').attr('original-text'));
        }

        // update all folder stats
        $("#folderTreeview").jstree('set_text', '#all', $('#all').attr('original-text') + ' (' + data.totalActiveFiles + ')');

        // update total storage stats
        $(".remaining-storage .progress .progress-bar").attr('aria-valuenow', data.totalStoragePercentage);
        $(".remaining-storage .progress .progress-bar").width(data.totalStoragePercentage + '%');
        $("#totalActiveFileSize").html(data.totalActiveFileSizeFormatted);

        // ensure breadcrumbs are up to date
        refreshFolderBreadcrumbs();
    }

    function isDesktopUser()
    {
        if ((getBrowserWidth() <= 1024) && (getBrowserWidth() > 0))
        {
            return false;
        }

        return true;
    }

    function getBrowserWidth()
    {
        return $(window).width();
    }

    function duplicateFiles(fromFileDetails)
    {
        if (typeof (fromFileDetails) == 'undefined')
        {
            fromFileDetails = false;
        }

        if (countSelected() > 0)
        {
            text = "<?php echo str_replace('"', '\"', t('file_manager_are_you_sure_you_want_to_duplicate_x_files', 'Are you sure you want to duplicate the selected [[[TOTAL_FILES]]] file(s)?')); ?>";
            text = text.replace('[[[TOTAL_FILES]]]', countSelected());
            if (confirm(text))
            {
                duplicateFilesConfirm(fromFileDetails);
            } else
            {
                // clear selected if only 1
                if (countSelected() == 1)
                {
                    clearSelectedItems();
                }
            }
        }

        return false;
    }

    function duplicateFilesConfirm(fromFileDetails)
    {
        if (typeof (fromFileDetails) == 'undefined')
        {
            fromFileDetails = false;
        }

        // clear file details popup
        if (fromFileDetails == true)
        {
            jQuery('#fileDetailsModal').modal('hide');
        }

        // show loader
        showLoaderModal(0);

        // prepare file ids
        fileIds = getAllSelectedFileIds();

        // duplicate files
        $.ajax({
            type: "POST",
            url: "<?php echo CORE_AJAX_WEB_ROOT; ?>/_file_manage_bulk_duplicate.ajax.php",
            data: {fileIds: fileIds},
            dataType: 'json',
            success: function (json) {
                if (json.error == true)
                {
                    // hide loader
                    hideLoaderModal();
                    $('#filePopupContentNotice').html(json.msg);
                    showLightboxNotice();
                } else
                {
                    // done
                    addBulkSuccess(json.msg);
                    finishBulkProcess();
                }

            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                $('#popupContentNotice').html('Failed connecting to server, please try again later.');
                showLightboxNotice();
            }
        });
    }

    function loadFolderFiles(folderId)
    {
        setCurrentFolderId(folderId);
        refreshFolderBreadcrumbs();
        loadFiles();
    }

    function showFolderSharingForm(folderId)
    {
        showLoaderModal();
        jQuery('#shareFolderModal .modal-content').load("<?php echo WEB_ROOT; ?>/ajax/_account_share_folder.ajax.php", {folderId: folderId}, function () {
            hideLoaderModal();
            jQuery('#shareFolderModal').modal('show', {backdrop: 'static'});
            createdUrl = false;

            // hover over tooptips
            setupToolTips();
        });
    }

    callbackcheck = false;
    function showStatsPopup(fileId)
    {
        showLoaderModal();
        jQuery('#statsModal .modal-content').load("<?php echo WEB_ROOT; ?>/ajax/_file_stats.ajax.php", {fileId: fileId}, function () {
            hideLoaderModal();
            jQuery('#statsModal').modal('show', {backdrop: 'static'}).on('show');

            // redraw charts, this is needed otherwise the charts wont show
            callbackcheck = setTimeout(function () {
                redrawCharts();
                clearTimeout(callbackcheck);
            }, 200);
        });
    }

    var createdUrl = false;
    function generateFolderSharingUrl(folderId)
    {
        $.ajax({
            dataType: "json",
            url: "<?php echo CORE_AJAX_WEB_ROOT; ?>/_generate_folder_sharing_url.ajax.php",
            data: {folderId: folderId},
            success: function (data) {
                if (data.error == true)
                {
                    showErrorNotification('Error', data.msg);
                } else
                {
                    $('#sharingUrlInput').html(data.msg);
                    $('#shareEmailFolderUrl').html(data.msg);
                    $('#nonPublicSharingUrls').fadeIn();
                    $('#nonPublicSharingUrls').html($('.social-wrapper-template').html().replace(/SHARE_LINK/g, data.msg));
                    createdUrl = true;
                }
            }
        });
    }
</script>

<?php
// output any extra account home javascript
pluginHelper::includeAppends('account_home_javascript.php');
?>