<?php
// local template functions
require_once(SITE_TEMPLATES_PATH . '/partial/_template_functions.inc.php');

// load theme functions
$themeObj = themeHelper::getLoadedInstance();
$themeSkin = $themeObj->getThemeSkin();
$homepageBackgroundImageUrl = $themeObj->getHomepageBackgroundImageUrl();
$homepageBackgroundVideoUrl = $themeObj->getHomepageBackgroundVideoUrl();

// top navigation
require_once(SITE_TEMPLATES_PATH . '/partial/_navigation_header.inc.php');
?>
<!DOCTYPE html>
<html lang="en" dir="<?php echo SITE_LANGUAGE_DIRECTION == 'RTL' ? 'RTL' : 'LTR'; ?>" class="direction<?php echo SITE_LANGUAGE_DIRECTION == 'RTL' ? 'Rtl' : 'Ltr'; ?>">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <title><?php echo validation::safeOutputToScreen(PAGE_NAME); ?> - <?php echo validation::safeOutputToScreen(SITE_CONFIG_SITE_NAME); ?></title>
        <meta name="description" content="<?php echo validation::safeOutputToScreen(PAGE_DESCRIPTION); ?>" />
        <meta name="keywords" content="<?php echo validation::safeOutputToScreen(PAGE_KEYWORDS); ?>" />
        <meta name="copyright" content="Copyright &copy; <?php echo date("Y"); ?> - <?php echo validation::safeOutputToScreen(SITE_CONFIG_SITE_NAME); ?>" />
        <meta name="robots" content="all" />
        <meta http-equiv="Cache-Control" content="no-cache" />
        <meta http-equiv="Expires" content="-1" />
        <meta http-equiv="Pragma" content="no-cache" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <?php pluginHelper::includeAppends('main_page_header.php', array('file' => (isset($file) ? $file : null), 'Auth' => $Auth)); ?>
        <meta property="og:image" content="<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/apple-touch-icon-114x114.png" />
        <link rel="icon" type="image/x-icon" href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/favicon.ico" />

        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Lato:100,300,400,400i,700,700i,900&amp;subset=latin-ext" rel="stylesheet"> 
		<link href="https://fonts.googleapis.com/css?family=Montserrat:100,200,300,300i,400,400i,500,600,700,800,900" rel="stylesheet"> 
        
        <!-- All Stylesheets -->
        <link href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/css/custom.css" rel="stylesheet">
        <link href="<?php echo SITE_THEME_PATH; ?>/hg/css/bootstrap.css" rel="stylesheet">
		<link href="<?php echo SITE_THEME_PATH; ?>/hg/css/hg.css" rel="stylesheet">
		<link rel="stylesheet" href="<?php echo SITE_THEME_PATH; ?>/hg/line-awesome/css/line-awesome.min.css">
		<link href="<?php echo SITE_THEME_PATH; ?>/hg/css/ie10-viewport-bug-workaround.css" rel="stylesheet">
	    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/material-design-iconic-font/2.2.0/css/material-design-iconic-font.min.css">
	    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:200,300,400,600,700,900" rel="stylesheet">
        <link href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/css/responsive.css" rel="stylesheet">
        <link href="<?php echo SITE_CSS_PATH; ?>/font-icons/entypo/css/entypo.css" rel="stylesheet">
        <link href="<?php echo SITE_CSS_PATH; ?>/file-upload.css" rel="stylesheet">
		<link href="<?php echo SITE_CSS_PATH; ?>/cookieconsent.min.css" rel="stylesheet" />
        <?php echo $themeObj->outputCustomCSSCode(); ?>

        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
        <![endif]-->
        <!-- Fav and touch icons -->		
        <link rel="apple-touch-icon-precomposed" sizes="114x114" href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/apple-touch-icon-114x114.png">
        <link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/apple-touch-icon-72x72.png">
        <link rel="apple-touch-icon-precomposed" href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/apple-touch-icon.png">
        <link rel="shortcut icon" href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/favicon.png">
        <script src="https://use.fontawesome.com/ed0a1e021d.js"></script>
        <script type="text/javascript">
            var WEB_ROOT = "<?php echo WEB_ROOT; ?>";
            <?php echo translate::generateJSLanguageCode(); ?>
        </script>
		<script src="<?php echo SITE_THEME_PATH; ?>/hg/js/progress.js"></script>
        <?php
        // add js files, use the htmlHelper::addJsFile() function so files can be joined/minified
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery-1.11.0.min.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery-ui.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.dataTables.min.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.tmpl.min.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/load-image.min.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/canvas-to-blob.min.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.iframe-transport.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-process.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-resize.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-validate.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-ui.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/zeroClipboard/ZeroClipboard.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/global.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/cookieconsent.min.js');

        // output js
        pluginHelper::outputJs();
        ?>
        
        <?php if(SITE_CONFIG_SHOW_COOKIE_NOTICE === 'yes'): ?>
        <script>
        window.addEventListener("load", function(){
        window.cookieconsent.initialise({
          "palette": {
            "popup": {
              "background": "#000"
            },
            "button": {
              "background": "#f1d600"
            }
          },
          "theme": "classic",
          "content": {
            href: "<?php echo WEB_ROOT; ?>/privacy.html",
            message: "<?php echo addslashes(str_replace(array("\n", "\r"),"", t('cookie_notice_this_website_uses', 'This website uses cookies to ensure you get the best experience on our website.'))); ?>",
            header: "<?php echo addslashes(str_replace(array("\n", "\r"),"", t('cookie_notice_cookies_used_on_the_website', 'Cookies used on the website!'))); ?>",
            dismiss: "<?php echo addslashes(str_replace(array("\n", "\r"),"", t('cookie_notice_got_it', 'Got it!'))); ?>",
            allow: "<?php echo addslashes(str_replace(array("\n", "\r"),"", t('cookie_notice_allow_cookies', 'Allow cookies'))); ?>",
            deny: "<?php echo addslashes(str_replace(array("\n", "\r"),"", t('cookie_notice_decline', 'Decline'))); ?>",
            link: "<?php echo addslashes(str_replace(array("\n", "\r"),"", t('cookie_notice_learn_more', 'Learn more'))); ?>"
          }
        })});
        </script>
        <?php endif; ?>
		<script src="<?php echo SITE_THEME_PATH; ?>/hg/js/ie-emulation-modes-warning.js"></script>
    </head>
    <body>
    <?php
	// adblock notification, if enabled via the site settings
	include_once(SITE_TEMPLATES_PATH . '/partial/_ad_block.inc.php');
	?>
    <nav class="navbar navbar-inverse"  id="navigation">
	  <div class="container">
        <div class="navbar-header">
          <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
            <span class="sr-only">Toggle navigation</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
          </button>
          <a class="navbar-brand" href="<?php echo coreFunctions::getCoreSitePath(); ?>">HGFiles</a> 
        </div>
		
		<div id="navbar" class="collapse navbar-collapse">
		   <ul class="nav navbar-nav">
            <li><a href="<?php echo coreFunctions::getCoreSitePath(); ?>/upgrade.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="la la-star zmdi-hc-lg"></i> Premium</a></li>
			<li><a href="<?php echo coreFunctions::getCoreSitePath(); ?>/search.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="la la-search zmdi-hc-lg"></i> Search</a></li>
		  </ul>
		  <ul class="nav navbar-nav navbar-right">
            <?php
                // add any other navigation items
                $headerNavigation = pluginHelper::generateHeaderNavStructure($headerNavigation, $Auth->level_id);

                // format nagivation for template
                $navigationHtmlItems = array();
                    foreach ($headerNavigation AS $headerNavigationItem)
                {
                
                                
                $navHtml = '<li';
               
                $navHtml .= '><a class="' . $headerNavigationItem['class'] . '" href="' . $headerNavigationItem['link_url'] . '"';
                if (isset($headerNavigationItem['element_id']))
                {
                    $navHtml .= ' id="' . validation::safeOutputToScreen($headerNavigationItem['element_id']) . '"';
                }
                $navHtml .= '><i class="la la-' . validation::safeOutputToScreen($headerNavigationItem['icon']) . ' zmdi-hc-lg"></i> ' . validation::safeOutputToScreen($headerNavigationItem['link_text']) . '</a></li>';

                if (isset($headerNavigationItem['wrap_html']))
                {
                    $navHtml = str_replace('[[[NAV_ITEM_HTML]]]', $navHtml, $headerNavigationItem['wrap_html']);
                }

                $navigationHtmlItems[] = $navHtml;
            }

// output nav
            echo implode('', $navigationHtmlItems);
            ?>
			
			<?php
            if (SITE_CONFIG_SHOW_MULTI_LANGUAGE_SELECTOR == 'show')
            {
                $activeLanguages = $db->getRows("SELECT languageName, flag FROM language WHERE isActive = 1 ORDER BY isLocked DESC");
				if (COUNT($activeLanguages))
                {
                ?>
				<li class="lang dropdown">
			    <?php
                foreach ($activeLanguages AS $activeLanguage)
                {
                    echo '<a href="#" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false" class="dropdown-toggle ';
					if ($_SESSION['_t'] == $activeLanguage['languageName'])
                    {
                        echo 'show';
                    }
                    else
                    {
                        echo 'hidden';
                    }
                    echo '">';
                    
                    echo '<img src="' . SITE_IMAGE_PATH . '/flags/' . $activeLanguage['flag'] . '.png" width="20" height="14" alt="' . $activeLanguage['languageName'] . '">' . $activeLanguage['languageName'] . '</a>';
                }
                ?>
			    
				<ul class="dropdown-menu">
                <?php
                foreach ($activeLanguages AS $activeLanguage)
                {
                    echo '<li><a href="' . coreFunctions::getCoreSitePath() . '/index.' . SITE_CONFIG_PAGE_EXTENSION . '?_t=' . urlencode($activeLanguage['languageName']) . '">';
                    echo '<img src="' . SITE_IMAGE_PATH . '/flags/' . $activeLanguage['flag'] . '.png" width="20" height="14" alt="' . $activeLanguage['languageName'] . '" title="' . htmlentities(t('switch_site_language_to', 'Switch site language to') . ' ' . t($activeLanguage['languageName'], $activeLanguage['languageName'])) . '">';
                    
                    echo '' . $activeLanguage['languageName'] . '</a></li>';
                }
                ?>
                </ul>
                </li>
                <?php
                }
            }
            ?>
		  </ul>
        </div><!--/.nav-collapse -->
	  </div>
    </nav>
    
    
        <?php
        // if we're on the index page, show the uploader and slider
        if (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'index')
        {
            if (UserPeer::getAllowedToUpload() == true)
            {
                if (isset($_REQUEST['upload']))
                {
                    // auto show uploader
                    echo "<script>\n";
                    echo "$(document).ready(function() {\n";
                    echo "  showUploaderPopup();\n";
                    echo "});";
                    echo "</script>\n";
                }
                ?>
                <!-- uploader -->
                <div id="fileUploadWrapper" class="modal fade file-upload-wrapper">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <?php
                            // uploader code
                            require_once(SITE_TEMPLATES_PATH . '/partial/_uploader_home.inc.php');
                            ?>
                        </div>
                    </div>
                </div>
                <?php
            }
            ?>
            nxfxfn
            <?php
        }
        ?>
        <?php
        // if not index page
        if (!defined('CURRENT_PAGE_KEY') || CURRENT_PAGE_KEY != 'index'):
            ?>
            
    <div class="pages <?php echo validation::safeOutputToScreen(PLAYER); ?> <?php echo validation::safeOutputToScreen(CURRENT_PAGE_KEY); ?>Wxrea <?php echo validation::safeOutputToScreen(PAGE_NAME); ?> ">
	
	    <div class="container">  
			<div class="row">
			    <div class="col-sm-12 upl">
				    <h1><?php echo validation::safeOutputToScreen(PAGE_NAME); ?></h1>
					<?php if((defined('TITLE_DESCRIPTION_LEFT')) && (strlen(TITLE_DESCRIPTION_LEFT))): ?>
					<p><?php echo validation::safeOutputToScreen(TITLE_DESCRIPTION_LEFT); ?></p>
					<?php endif; ?>
				</div>
				
			</div>
		</div>
	</div>
            
            
                <div class="container">
                    <div class="row">
                    <?php endif; ?>