<?php
// local template functions
require_once(SITE_TEMPLATES_PATH . '/partial/_template_functions.inc.php');

// load theme functions
$themeObj = themeHelper::getLoadedInstance();
$themeSkin = $themeObj->getThemeSkin();

// top navigation
require_once(SITE_TEMPLATES_PATH . '/partial/_navigation_header.inc.php');

// per page options
$perPageOptions = array(15, 30, 50, 100, 250);
$defaultPerPage = 100;

// load all files
$sQL = "SELECT COUNT(id) AS total, "
        . "SUM(fileSize) AS totalFilesize, "
        . "status "
        . "FROM file "
        . "WHERE userId = :user_id "
        . "AND status IN ('active', 'trash') "
        . "GROUP BY status";
$totalData = $db->getRows($sQL, array(
    'user_id' => (int) $Auth->id,
        ));
$totalActiveFileSize = 0;
foreach ($totalData AS $totalDataItem) {
    if ($totalDataItem['status'] == 'active') {
        $totalActive = (int) $totalDataItem['total'];
        $totalActiveFileSize = (int) $totalDataItem['totalFilesize'];
    }
    else {
        $totalTrash = (int) $totalDataItem['total'];
    }
}

// account stats
$totalFileStorage = UserPeer::getMaxFileStorage($Auth->id);
$storagePercentage = 0;
if (($totalActiveFileSize > 0) && ($totalFileStorage > 0)) {
    $storagePercentage = ($totalActiveFileSize / $totalFileStorage) * 100;
    if ($storagePercentage < 1) {
        $storagePercentage = 1;
    }
    else {
        $storagePercentage = floor($storagePercentage);
    }
}

// header top
require_once(SITE_TEMPLATES_PATH . '/partial/_header_file_manager_top.inc.php');
?>
<body class="dash">
    <nav class="navbar navbar-inverse"  id="navigation">
	  <div class="container-fluid">
        
		<div class="navbar-header">
		  <a class="navbar-brand visible-xs" href="<?php echo coreFunctions::getCoreSitePath(); ?>" class="external"><img src="<?php echo $themeObj->getMainLogoUrl(); ?>" alt="<?php echo SITE_CONFIG_SITE_NAME; ?>"/></a> 
          <button type="button" class="navbar-toggle" id="open">
            <span class="sr-only">Toggle navigation</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
          </button>
        </div>
		
		<div id="navbar" class="collapse navbar-collapse">
		  <ul class="nav navbar-nav navbar-right">
            <!-- notifications -->
            <?php
            // load all in the past 14 days for current user
            $internalNotifications = internalNotification::loadRecentByUser($Auth->id);
            $unreadCount           = 0;
            foreach ($internalNotifications AS $internalNotification)
            {
                if ($internalNotification['is_read'] == 0)
                {
                    $unreadCount++;
                }
            }
            ?>
			<li class="notifications">
              <a href="#" class="" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                <i class="zmdi zmdi-notifications zmdi-hc-fw"></i>
				<?php if ($unreadCount > 0): ?>
				<span class="badge badge-warning"><?php echo $unreadCount; ?></span>
				<?php endif; ?>
			  </a>
              <ul class="dropdown-menu notifications-menu">
                <li class="top"><span><?php echo $unreadCount != 1 ?t('file_manager_you_have_x_new_notifications', 'You have <strong>[[[UNREAD]]]</strong> new notifications.', array('UNREAD' => $unreadCount)):t('file_manager_you_have_x_new_notification', 'You have <strong>[[[UNREAD]]]</strong> new notification.', array('UNREAD' => $unreadCount)); ?></span></li>
				<li class="notify-body">
				  <ul class="dropdown-menu-list scroller" style="overflow: hidden; outline: none;" tabindex="5000">
                    <?php foreach ($internalNotifications AS $internalNotification): ?>
					<li class="<?php echo $internalNotification['is_read'] == 0 ? 'unread' : 'read'; ?> notification-<?php echo $internalNotification['is_read'] == 0 ? 'info' : 'default'; ?>">
                      <a href="<?php echo strlen($internalNotification['href_url']) ? $internalNotification['href_url'] : '#'; ?>" <?php echo strlen($internalNotification['onclick']) ? (' onClick="' . addslashes($internalNotification['onclick']) . '"') : ''; ?>>
                        <span class=" <?php echo $internalNotification['is_read'] == 0 ? 'text-bold' : ''; ?>">
                            <?php echo $internalNotification['content']; // allow for html   ?>
                        </span>
                        <span class=" small">
                            <?php echo coreFunctions::timeToRelativeString($internalNotification['date_added']); ?>
                        </span>
                      </a>
                    </li>
					<?php endforeach; ?>
                  </ul> 
				</li>
				<?php if ($unreadCount > 0): ?>
				<li class="bottom-line"><a href="#" onClick="markInternalNotificationsRead();
                    return false;"><?php echo t("hg_MARK_READ", "Mark all read")?></a></li>
				<?php endif; ?>
              </ul>
            </li>
			
			<li class="dropdown">
              <a class="dropdown-toggle details" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
			  <span class="avatar">
			    <img class="img-circle" src="<?php echo CORE_PAGE_WEB_ROOT; ?>/account_view_avatar.php?width=34&height=34">
			  </span>
			  <?php echo validation::safeOutputToScreen($Auth->getAccountScreenName()); ?></a>
              <ul class="dropdown-menu">
                <?php
					// reload user level from database encase they've just upgraded
					$userLocal = UserPeer::loadUserById((int)$Auth->id);
					$packageId = $userLocal->level_id;
					if($packageId == 20):
						$label = 'ADMIN AREA';
				?>
				<li><a href="<?php echo ADMIN_WEB_ROOT.'/'; ?>" target="_blank"><i class="la la-cogs la-lg"></i> <?php echo t("hg_dmin_area", "Admin Area")?></a></li>
				<?php endif; ?>
                <li><a href="<?php echo coreFunctions::getCoreSitePath(); ?>/account_edit.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="la la-cog la-lg"></i> <?php echo t("hg_settings", "Settings")?></a></li>
                <li><a href="<?php echo coreFunctions::getCoreSitePath(); ?>/contact.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="la la-question-circle la-lg"></i> <?php echo t("hg_help", "Help")?></a></li>
                <li class="power"><a href="<?php echo coreFunctions::getCoreSitePath(); ?>/logout.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="la la-power-off la-lg"></i> <?php echo t("hg_logout", "Logout")?></a></li>
              </ul>
            </li>
		  </ul>
		  <div class="navbar-form navbar-right">
            <div class="input-group">
              <input type="text" class="form-control" oninput="doFilter(true); return false;" name="filterText" id="filterText" placeholder="Search files ..." value="<?php echo isset($filterText) ? validation::safeOutputToScreen($filterText) : ''; ?>">
              <span class="input-group-btn">
                <button class="btn btn-default" onClick="doFilter(true); return false;" type="button"><i class="la la-search"></i></button>
              </span>
			</div>
          </div>
        </div><!--/.nav-collapse -->
	  </div>
    </nav>
	<div class="dashboard">
	  <div class="sidebar">
	    <div class="logo text-center" align="center">
		  <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/index.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="la la-cloud-upload la-lg"></i></a>
		</div>
		<ul class="nav nav-pills nav-stacked">
		  <li class="nav-item" id="file-menu">
		    <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/account_home.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>" data-toggle="tooltip" data-placement="right" title="<?php echo t("hg_file_manager", "File Manager")?>"><i class="la la-folder la-lg"></i></a>
		  </li>
		  <li class="nav-item">
		    <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/search.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>" data-toggle="tooltip" data-placement="right" title="<?php echo t("hg_search", "Public Files")?>"><i class="la la-search la-lg"></i></a>
		  </li>
		  <li class="nav-item">
		    <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/upgrade.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>" data-toggle="tooltip" data-placement="right" title="<?php echo t("hg_upgrade", "Extend Account")?>"><i class="la la-diamond la-lg"></i></a>
		  </li>
		  <li class="nav-item" id="settings">
		    <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/account_edit.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>" data-toggle="tooltip" data-placement="right" title="<?php echo t("hg_account", "Account")?>"><i class="la la-cog la-lg"></i></a>
		  </li>
		</ul>
		<ul class="nav nav-pills nav-stacked log">
		  <li class="nav-item">
		    <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/logout.html" data-toggle="tooltip" data-placement="right" title="<?php echo t("hg_logout", "Logout")?>"><i class="la la-power-off la-lg"></i></a>
		  </li>
		</ul>
	  </div>