<?php
$days = array(7, 30, 90, 180, 365);
// get packages
$package_level_id = $db->getValue('SELECT id FROM user_level WHERE on_upgrade_page = 1 AND level_type = \'paid\' LIMIT 1');
if(!$package_level_id)
{
    echo '<p>ERROR: No packages found, please contact the support team. (at least 1 package needs to have the option of \'On Upgrade Page\' to \'Yes\' with \'Package Type\' of \'Paid\')</p>';
}
else
{
	// load all prices
	$prices = $db->getRows('SELECT id, pricing_label, period, price, package_pricing_type, download_allowance FROM user_level_pricing WHERE user_level_id = '.(int)$package_level_id.' ORDER BY price ASC');
	if(COUNT($prices) > 0)
	{
	?>
	<div class="row">
		<?php
		$pricingColSizePercent = floor(100/COUNT($prices));
		foreach ($prices AS $k => $price)
		{
			$priceStr = $price['price'];
			$days = 0;
			if($price['package_pricing_type'] == 'period')
			{
				$days = coreFunctions::convertStringDatePeriodToDays($price['period']); // for older plugin gateway code
			}
		?>
			<div class="col-md-5ths col-xs-6" style="width: <?php echo floor($pricingColSizePercent); ?>%;">
				<div class="hg-pro">
					<div class="hg-heading">
						<h3 class="text-center"><?php echo validation::safeOutputToScreen(UCWords(t(validation::removeInvalidCharacters(str_replace(' ', '_', strtolower($price['pricing_label'])), 'abcdefghijklmnopqrstuvwxyz12345678900'), $price['pricing_label']))); ?></h3>
					</div>
					<div class="hg-body text-center">
						<div class="curr"><?php echo SITE_CONFIG_COST_CURRENCY_SYMBOL; ?></div>
						<div class="am"><?php echo number_format(str_replace(",", "", $priceStr), 2); ?></div>
						<?php if($days > 0): ?>
						<div class="per-day">/ month</div>
						<?php endif; ?>
					</div>
					<ul class="hg-list">
						<li><?php echo UCWords(t('secure_payment', 'secure payment')); ?></li>
						<li><?php echo UCWords(t('safe_and_anonymous', '100% Safe & Anonymous')); ?></li>
						<li>Unlimited Traffic</li>
						<li>Direct Downloads</li>
						<li>Add-free Experience</li>
					</ul>
					<div class="hg-footer">
						<?php
						pluginHelper::outputPaymentLinks(array('days' => $days, 'price' => $price['price'], 'user_level_pricing_id' => $price['id'], 'user_level_package_id' => $package_level_id));
						?>
					</div>
				</div>
			</div>
		<?php
		}
		?>
	</div>
	<?php
	}
}
?>