<?php
// get packages
$packages = $db->getRows('SELECT id, level_id, label, level_type, max_storage_bytes FROM user_level WHERE on_upgrade_page = 1 ORDER BY level_type=\'free\' DESC, level_type=\'paid\' DESC, id ASC');
if ((!$packages) || COUNT($packages) == 0) {
    if (CURRENT_PAGE_KEY != 'index') {
        echo '<p>ERROR: No packages found, please contact the support team. (at least 1 package needs to have the option of \'On Upgrade Page\' to \'Yes\')</p>';
    }
} else {
    echo '<div class="bottommargin clearfix">';
    $colSize = floor(12 / COUNT($packages));
    $foundPaid = false;
    $tracker = 0;
    foreach ($packages AS $k => $package) {
        $mostPopular = false;
        if ($tracker == 1) {
            $mostPopular = true;
        }

        $boxClass = ' panel-blue';
        $boxAddText = '';
        $boxButtonClass = '';
        if ($mostPopular == true) {
            $boxClass = ' best-price panel-green';
            $boxAddText = '<span>' . t('most_popular', 'Most Popular') . '</span>';
            $boxButtonClass = ' bgcolor border-color';
        }

        // prepare package limits for later
        $hdStorage = (int) $package['max_storage_bytes'] == 0 ? UCWords(t('unlimited', 'unlimited')) : coreFunctions::formatSize($package['max_storage_bytes']);

        $footerContent = '';
        $pricePerMonth = '';
        $featuresHtml = '';
        $prices = array();
        switch ($package['level_type']) {
            case 'free':
                $pricePerMonth = strtoupper(t('free', 'free'));
                $featuresHtml = '<li class="list-group-item"><i class="fa fa-hdd-o"></i> ' . $hdStorage . ' ' . t('storage', 'Storage') . '</li>';
                $featuresHtml .= '<li class="list-group-item"><i class="fa fa-user"></i> ' . t('unique_members_area', 'Unique Members Area') . '</li>';
                $featuresHtml .= '<li class="list-group-item"><i class="fa fa-bullhorn"></i> ' . t('advert_supported', 'Advert Supported') . '</li>';

                // different button for logged in users
                if ($Auth->loggedIn()) {
                    $pricingButton = '<a href="' . coreFunctions::getCoreSitePath() . '/account_home.' . SITE_CONFIG_PAGE_EXTENSION . '" class="btn btn-danger btn-block btn-lg' . $boxButtonClass . '">' . strtoupper(t('your_account', 'Your Account')) . '</a>';
                } else {
                    $pricingButton = '<a href="' . coreFunctions::getCoreSitePath() . '/register.' . SITE_CONFIG_PAGE_EXTENSION . '" class="btn btn-danger btn-block btn-lg' . $boxButtonClass . '">' . strtoupper(t('register_now', 'Register Now')) . '</a>';
                }
                break;
            case 'paid':
                // load all prices
                $period = '1M';
                $prices = $db->getRows('SELECT id, pricing_label, period, price FROM user_level_pricing WHERE user_level_id = ' . (int) $package['level_id'] . ' ORDER BY price ASC');
                if (COUNT($prices) > 0) {
                    // get lowest price
                    $lowest = null;
                    foreach ($prices AS $price) {
                        if ($lowest !== null) {
                            continue;
                        }
                        $lowest = $price['price'];
                        $period = $price['period'];
                    }
                    $pricePerMonth = $lowest;
                } else {
                    $pricePerMonth = strtoupper(t('free', 'free'));
                }

                $tracker++;
                if (CURRENT_PAGE_KEY == 'index') {
                    $pricingButton = '<a href="' . coreFunctions::getCoreSitePath() . '/upgrade.' . SITE_CONFIG_PAGE_EXTENSION . '?p=' . (int) $package['id'] . '" class="btn btn-danger btn-block btn-lg' . $boxButtonClass . '">' . strtoupper(t('upgrade_now', 'Upgrade Now'))
                            . '</a>';
                } else {
                    $pricingButton = '<a href="#" class="btn btn-danger btn-block btn-lg' . $boxButtonClass . '" data-toggle="modal" data-target="#pricing' . (int) $package['id'] . '">' . strtoupper(t('upgrade_now', 'Upgrade Now'))
                            . '</a>';
                }
                $foundPaid = true;

                $featuresHtml = '<li class="list-group-item"><i class="fa fa-hdd-o"></i> ' . $hdStorage . ' ' . t('storage', 'Storage') . '</li>';
                $featuresHtml .= '<li class="list-group-item"><i class="fa fa-user"></i> ' . t('unique_members_area', 'Unique Members Area') . '</li>';
                $featuresHtml .= '<li class="list-group-item"><i class="fa fa-check"></i> ' . t('advert_free', 'No Adverts') . '</li>';
                $featuresHtml .= '<li class="list-group-item"><i class="fa fa-lock"></i> ' . t('secure_payment', 'Secure Payment') . '</li>';
                $featuresHtml .= '<li class="list-group-item"><i class="fa fa-eye-slash"></i> ' . t('safe_and_anonymous', '100% Safe & Anonymous') . '</li>';
                if ($mostPopular == true) {
                    $featuresHtml .= '<li class="list-group-item"><i class="icon-star3"></i><i class="icon-star3"></i><i class="icon-star3"></i><i class="icon-star3"></i><i class="icon-star3"></i></li>';
                }
                break;
        }
        ?>
        <?php
        // output html for payment popup
        if ((COUNT($prices) > 0) && (CURRENT_PAGE_KEY != 'index')) {
            echo '<div id="pricing' . $package['id'] . '" class="col-md-4 col-xs-6">';
            $pricingColSizePercent = floor(100 / (COUNT($prices) + 1));
            $totalPercent = 0;
            foreach ($prices AS $k => $price) {
                // make sure the last column fills the remaining space
                if (($k + 1) == COUNT($prices)) {
                    $pricingColSizePercent = 100 - $totalPercent;
                }

                $priceStr = $price['price'];
                $days = coreFunctions::convertStringDatePeriodToDays($price['period']); // for older plugin gateway code
                ?>
                <div class="pricing<?php echo validation::safeOutputToScreen(UCWords(t(validation::removeInvalidCharacters(str_replace(' ', '_', strtolower($price['period'])), 'abcdefghijklmnopqrstuvwxyz12345678900'), $price['period']))); ?>">
				<div class="hg-pro">
					<div class="hg-heading">
						<h3 class="text-center"><?php echo validation::safeOutputToScreen(UCWords(t(validation::removeInvalidCharacters(str_replace(' ', '_', strtolower($price['pricing_label'])), 'abcdefghijklmnopqrstuvwxyz12345678900'), $price['pricing_label']))); ?></h3>
					</div>
					<div class="hg-body text-center">
						<div class="curr"><?php echo SITE_CONFIG_COST_CURRENCY_SYMBOL; ?></div>
						<div class="am"><?php echo number_format(str_replace(",", "", $priceStr), 2); ?></div>
						<?php if($days > 0): ?>
						<div class="per-day">/ <?php echo validation::safeOutputToScreen(UCWords(t(validation::removeInvalidCharacters(str_replace(' ', '_', strtolower($price['period'])), 'abcdefghijklmnopqrstuvwxyz12345678900'), $price['period']))); ?></div>
						<?php endif; ?>
					</div>
					<ul class="hg-list">
						<li><?php echo UCWords(t('secure_payment', 'secure payment')); ?></li>
						<li><?php echo UCWords(t('safe_and_anonymous', '100% Safe & Anonymous')); ?></li>
						<li><?php echo UCWords(t('unlimited_traffic', 'Unlimited Traffic')); ?></li>
						<li><?php echo UCWords(t('direct_downloads', 'Direct Downloads')); ?></li>
						<li><?php echo UCWords(t('add_free', 'Add-free Experience')); ?></li>
					</ul>
					<div class="hg-footer">
						<?php
						pluginHelper::outputPaymentLinks(array('days' => $days, 'price' => $price['price'], 'user_level_pricing_id' => $price['id'], 'user_level_package_id' => $package_level_id));
						?>
					</div>
				</div>
			</div>
                <?php
                $totalPercent = $totalPercent + $pricingColSizePercent;
            }
            echo '</div>';
        }
    }

    echo '<div class="clearfix"></div>';
}
